/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.backoff;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomBackoffStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class RandomExponentialBackoffStrategy
implements BackoffStrategy {
    private RandomBackoffStrategy randomBackoffStrategy = new RandomBackoffStrategy(10);
    private ExponentialBackoffStrategy exponentialBackoffStrategy = new ExponentialBackoffStrategy();

    @Override
    public long getMillisToWait(int numberOfTriesFailed, Duration delayBetweenAttempts) {
        long millisToWaitFromExpBackoff = this.exponentialBackoffStrategy.getMillisToWait(numberOfTriesFailed, delayBetweenAttempts);
        long millisToWait = this.randomBackoffStrategy.getMillisToWait(numberOfTriesFailed, Duration.of(millisToWaitFromExpBackoff, ChronoUnit.MILLIS));
        return millisToWait;
    }
}

