/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.FibonacciBackoffStrategy;
import com.evanlennick.retry4j.backoff.FixedBackoffStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;

public class RetryConfig {
    private Boolean retryOnAnyException = false;
    private Set<Class<? extends Exception>> retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
    private Integer maxNumberOfTries;
    private Duration delayBetweenRetries;
    private BackoffStrategy backoffStrategy;

    public Boolean isRetryOnAnyException() {
        return this.retryOnAnyException;
    }

    public void setRetryOnAnyException(boolean retryOnAnyException) {
        this.retryOnAnyException = retryOnAnyException;
    }

    public Set<Class<? extends Exception>> getRetryOnSpecificExceptions() {
        return this.retryOnSpecificExceptions;
    }

    public void setRetryOnSpecificExceptions(Set<Class<? extends Exception>> retryOnSpecificExceptions) {
        this.retryOnSpecificExceptions = retryOnSpecificExceptions;
    }

    public Integer getMaxNumberOfTries() {
        return this.maxNumberOfTries;
    }

    public void setMaxNumberOfTries(int maxNumberOfTries) {
        this.maxNumberOfTries = maxNumberOfTries;
    }

    public Duration getDelayBetweenRetries() {
        return this.delayBetweenRetries;
    }

    public void setDelayBetweenRetries(Duration delayBetweenRetries) {
        this.delayBetweenRetries = delayBetweenRetries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public static RetryConfig simpleFixedConfig() {
        RetryConfig config = new RetryConfig();
        config.retryOnAnyException = true;
        config.retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
        config.maxNumberOfTries = 5;
        config.delayBetweenRetries = Duration.of(10L, ChronoUnit.SECONDS);
        config.backoffStrategy = new FixedBackoffStrategy();
        return config;
    }

    public static RetryConfig simpleExponentialConfig() {
        RetryConfig config = new RetryConfig();
        config.retryOnAnyException = true;
        config.retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
        config.maxNumberOfTries = 5;
        config.delayBetweenRetries = Duration.of(5L, ChronoUnit.SECONDS);
        config.backoffStrategy = new ExponentialBackoffStrategy();
        return config;
    }

    public static RetryConfig simpleFibonacciConfig() {
        RetryConfig config = new RetryConfig();
        config.retryOnAnyException = true;
        config.retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
        config.maxNumberOfTries = 7;
        config.delayBetweenRetries = Duration.of(7L, ChronoUnit.SECONDS);
        config.backoffStrategy = new FibonacciBackoffStrategy();
        return config;
    }

    public String toString() {
        return "RetryConfig{retryOnAnyException=" + this.retryOnAnyException + ", retryOnSpecificExceptions=" + this.retryOnSpecificExceptions + ", maxNumberOfTries=" + this.maxNumberOfTries + ", delayBetweenRetries=" + this.delayBetweenRetries + ", backoffStrategy=" + this.backoffStrategy + '}';
    }
}

