/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j;

import com.evanlennick.retry4j.RetryConfig;
import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.FibonacciBackoffStrategy;
import com.evanlennick.retry4j.backoff.FixedBackoffStrategy;
import com.evanlennick.retry4j.backoff.NoWaitBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomExponentialBackoffStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;

public class RetryConfigBuilder {
    private RetryConfig config = new RetryConfig();

    public RetryConfigBuilder retryOnAnyException() {
        this.config.setRetryOnAnyException(true);
        return this;
    }

    public RetryConfigBuilder failOnAnyException() {
        this.config.setRetryOnAnyException(false);
        this.config.setRetryOnSpecificExceptions(new HashSet<Class<? extends Exception>>());
        return this;
    }

    @SafeVarargs
    public final RetryConfigBuilder retryOnSpecificExceptions(Class<? extends Exception> ... exceptions) {
        HashSet<Class<? extends Exception>> setOfExceptions = new HashSet<Class<? extends Exception>>(Arrays.asList(exceptions));
        this.config.setRetryOnSpecificExceptions(setOfExceptions);
        return this;
    }

    public RetryConfigBuilder withMaxNumberOfTries(int max) {
        this.config.setMaxNumberOfTries(max);
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(Duration duration) {
        this.config.setDelayBetweenRetries(duration);
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(int seconds) {
        this.config.setDelayBetweenRetries(Duration.of(seconds, ChronoUnit.SECONDS));
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(long millis) {
        this.config.setDelayBetweenRetries(Duration.of(millis, ChronoUnit.MILLIS));
        return this;
    }

    public RetryConfigBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.config.setBackoffStrategy(backoffStrategy);
        return this;
    }

    public RetryConfigBuilder withFixedBackoff() {
        this.config.setBackoffStrategy(new FixedBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withExponentialBackoff() {
        this.config.setBackoffStrategy(new ExponentialBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withFibonacciBackoff() {
        this.config.setBackoffStrategy(new FibonacciBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withNoWaitBackoff() {
        this.config.setBackoffStrategy(new NoWaitBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withRandomBackoff() {
        this.config.setBackoffStrategy(new RandomBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withRandomExponentialBackoff() {
        this.config.setBackoffStrategy(new RandomExponentialBackoffStrategy());
        return this;
    }

    public RetryConfig build() {
        return this.config;
    }
}

