/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.util.cluster.hazelcast;

import com.eurodyn.qlack2.util.cluster.core.QlackClusterListener;
import com.eurodyn.qlack2.util.cluster.core.QlackClusterService;
import com.eurodyn.qlack2.util.cluster.hazelcast.HazelcastMessageListener;
import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class QlackClusterServiceImpl
implements QlackClusterService {
    private static final Logger LOGGER = Logger.getLogger(QlackClusterServiceImpl.class.getName());
    private HazelcastInstance instance;
    private String interfaces;

    public void setInterfaces(String interfaces) {
        this.interfaces = interfaces;
    }

    public void init() {
        LOGGER.log(Level.CONFIG, "Initialising Hazelcast.");
        Config cfg = new Config();
        if (StringUtils.isNotBlank((CharSequence)this.interfaces)) {
            NetworkConfig nc = new NetworkConfig();
            InterfacesConfig ic = new InterfacesConfig();
            ic.setEnabled(true);
            for (String i : Arrays.asList(this.interfaces.split(","))) {
                LOGGER.log(Level.CONFIG, "Enabling interface: {0}", i);
                ic.addInterface(i);
                nc.setInterfaces(ic);
            }
            cfg.setNetworkConfig(nc);
        }
        this.instance = Hazelcast.newHazelcastInstance((Config)cfg);
    }

    public void destroy() {
        LOGGER.log(Level.CONFIG, "Shutting down Hazelcast");
        this.instance.shutdown();
    }

    public void publish(String topic, String message) {
        LOGGER.log(Level.FINEST, "Sending a message to the cluster: {0}.", message);
        ITopic hazelcastTopic = this.instance.getTopic(topic);
        hazelcastTopic.publish((Object)message);
    }

    public String addListener(QlackClusterListener qlc, String topic) {
        return this.instance.getTopic(topic).addMessageListener((MessageListener)new HazelcastMessageListener(qlc));
    }

    public boolean removeListener(String registrationID, String topic) {
        return this.instance.getTopic(topic).removeMessageListener(registrationID);
    }
}

