/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.fuse.imaging.impl;

import com.eurodyn.qlack2.fuse.imaging.api.ImagingService;
import com.eurodyn.qlack2.fuse.imaging.api.dto.ImageFormatHandler;
import com.eurodyn.qlack2.fuse.imaging.api.dto.ImageInfo;
import com.eurodyn.qlack2.fuse.imaging.api.exception.QImagingException;
import com.eurodyn.qlack2.fuse.imaging.api.util.ColorSpaceType;
import com.eurodyn.qlack2.fuse.imaging.api.util.ICCProfile;
import com.eurodyn.qlack2.fuse.imaging.api.util.ResamplingAlgorithm;
import com.eurodyn.qlack2.fuse.imaging.api.util.TIFFCompression;
import com.eurodyn.qlack2.fuse.imaging.impl.util.ImagingUtil;
import com.twelvemonkeys.image.ResampleOp;
import java.awt.Color;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.osgi.framework.BundleContext;

@Singleton
@OsgiServiceProvider(classes={ImagingService.class})
public class ImagingServiceImpl
implements ImagingService {
    @Inject
    BundleContext bundleContext;

    private byte[] resample(BufferedImage originalImage, int width, int height, ResamplingAlgorithm resamplingAlgorithm, String imageType) throws IOException {
        try (ByteArrayOutputStream resampledImageOutputStream = new ByteArrayOutputStream();){
            ResampleOp resampler = new ResampleOp(width, height, resamplingAlgorithm.getVal());
            ImageIO.write((RenderedImage)resampler.filter(originalImage, null), imageType, resampledImageOutputStream);
            resampledImageOutputStream.flush();
            byte[] byArray = resampledImageOutputStream.toByteArray();
            return byArray;
        }
    }

    @PostConstruct
    public void init() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        registry.registerServiceProviders(ServiceRegistry.lookupProviders(ImageReaderSpi.class));
        registry.registerServiceProviders(ServiceRegistry.lookupProviders(ImageWriterSpi.class));
    }

    public List<ImageFormatHandler> getSupportedReadFormats() {
        ArrayList<ImageFormatHandler> handlers = new ArrayList<ImageFormatHandler>();
        for (String reader : ImageIO.getReaderFormatNames()) {
            ImageFormatHandler imageFormatHandler = new ImageFormatHandler();
            imageFormatHandler.setFormat(reader);
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByFormatName(reader);
            while (imageReaders.hasNext()) {
                ImageReader next = imageReaders.next();
                imageFormatHandler.addHandlerClass(next.toString());
            }
            handlers.add(imageFormatHandler);
        }
        return handlers;
    }

    public List<ImageFormatHandler> getSupportedWriteFormats() {
        ArrayList<ImageFormatHandler> handlers = new ArrayList<ImageFormatHandler>();
        for (String reader : ImageIO.getWriterFormatNames()) {
            ImageFormatHandler imageFormatHandler = new ImageFormatHandler();
            imageFormatHandler.setFormat(reader);
            Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(reader);
            while (imageWriters.hasNext()) {
                ImageWriter next = imageWriters.next();
                imageFormatHandler.addHandlerClass(next.toString());
            }
            handlers.add(imageFormatHandler);
        }
        return handlers;
    }

    public boolean isFormatSupportedForRead(String format) {
        return this.getSupportedReadFormats().stream().anyMatch(o -> o.getFormat().equals(format));
    }

    public boolean isFormatSupportedForWrite(String format) {
        return this.getSupportedWriteFormats().stream().anyMatch(o -> o.getFormat().equals(format));
    }

    public ImageInfo getInfo(byte[] image) {
        ImageInfo imageInfo = null;
        try {
            imageInfo = new ImageInfo();
            try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
                BufferedImage bufferedImage = ImageIO.read(originalImageInputStream);
                imageInfo.setBitsPerPixel(bufferedImage.getColorModel().getPixelSize());
                imageInfo.setColorType(ColorSpaceType.valueOf((String)ColorSpaceType.getReverseVal((int)bufferedImage.getColorModel().getColorSpace().getType())));
                imageInfo.setHeight(bufferedImage.getHeight());
                imageInfo.setWidth(bufferedImage.getWidth());
                try (ByteArrayInputStream originalImageInputStream2 = new ByteArrayInputStream(image);){
                    imageInfo.setMimeType(new TikaConfig().getDetector().detect((InputStream)originalImageInputStream2, new Metadata()).toString());
                }
                imageInfo.setDotsPerInch(ImagingUtil.getDPI(image));
                imageInfo.setFormat(ImagingUtil.getType(image));
            }
        }
        catch (IOException | TikaException e) {
            throw new QImagingException("Could not obtain image info.", e);
        }
        return imageInfo;
    }

    public byte[] convert(byte[] image, String dstFormat) {
        return this.convert(image, dstFormat, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] removeAlphaChannel(byte[] image) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String type = ImagingUtil.getType(image);
            try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
                BufferedImage originalImage = ImageIO.read(originalImageInputStream);
                BufferedImage newImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
                newImage.createGraphics().drawImage(originalImage, 0, 0, Color.BLACK, null);
                ImageIO.write((RenderedImage)newImage, type, baos);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new QImagingException("Could not remove alpha channel.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] convert(byte[] image, String dstFormat, ICCProfile dstColorspace) {
        try (ByteArrayOutputStream dstImage = new ByteArrayOutputStream();){
            try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
                BufferedImage originalImage = ImageIO.read(originalImageInputStream);
                if (dstColorspace != null) {
                    String iccProfileFile = "icc/" + dstColorspace.name() + ".icc";
                    ICC_ColorSpace cmykColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(this.bundleContext.getBundle().getResource(iccProfileFile).openStream()));
                    ColorConvertOp op = new ColorConvertOp(originalImage.getColorModel().getColorSpace(), cmykColorSpace, null);
                    originalImage = op.filter(originalImage, null);
                }
                if (!ImageIO.write((RenderedImage)originalImage, dstFormat, dstImage)) {
                    throw new QImagingException(MessageFormat.format("Could not write destination format: {0}", dstFormat));
                }
            }
            byte[] byArray = dstImage.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not convert image.", (Throwable)e);
        }
    }

    public byte[] convertToTIFF(byte[] image, TIFFCompression tiffCompression) {
        return this.convertToTIFF(image, null, tiffCompression);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] convertToTIFF(byte[] image, ICCProfile dstColorspace, TIFFCompression tiffCompression) {
        try (ByteArrayOutputStream convertedImage = new ByteArrayOutputStream();){
            try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
                BufferedImage originalImage = ImageIO.read(originalImageInputStream);
                if (dstColorspace != null) {
                    String iccProfileFile = "icc/" + dstColorspace.name() + ".icc";
                    ICC_ColorSpace cmykColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(this.bundleContext.getBundle().getResource(iccProfileFile).openStream()));
                    ColorConvertOp op = new ColorConvertOp(originalImage.getColorModel().getColorSpace(), cmykColorSpace, null);
                    originalImage = op.filter(originalImage, null);
                }
                ImageWriteParam params = ImageIO.getImageWritersByFormatName("TIFF").next().getDefaultWriteParam();
                params.setCompressionMode(2);
                params.setCompressionType(tiffCompression.getVal());
                try (ImageOutputStream ios = ImageIO.createImageOutputStream(convertedImage);){
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("TIFF").next();
                    writer.setOutput(ios);
                    writer.write(null, new IIOImage(originalImage, null, null), params);
                }
            }
            byte[] byArray = convertedImage.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not convert image.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] resampleByPercent(byte[] image, int percent, ResamplingAlgorithm resamplingAlgorithm) {
        try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
            BufferedImage originalBufferedImage = ImageIO.read(originalImageInputStream);
            byte[] byArray = this.resample(originalBufferedImage, (int)((float)originalBufferedImage.getWidth() * ((float)percent / 100.0f)), (int)((float)originalBufferedImage.getHeight() * ((float)percent / 100.0f)), resamplingAlgorithm, ImagingUtil.getType(image));
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not resample image by percent.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] resampleByFactor(byte[] image, float factor, ResamplingAlgorithm resamplingAlgorithm) {
        try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
            BufferedImage originalBufferedImage = ImageIO.read(originalImageInputStream);
            byte[] byArray = this.resample(originalBufferedImage, (int)((float)originalBufferedImage.getWidth() * factor), (int)((float)originalBufferedImage.getHeight() * factor), resamplingAlgorithm, ImagingUtil.getType(image));
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not resample image by factor.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] resampleByWidth(byte[] image, int width, ResamplingAlgorithm resamplingAlgorithm) {
        try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
            BufferedImage originalBufferedImage = ImageIO.read(originalImageInputStream);
            float newYRatio = (float)width / (float)originalBufferedImage.getWidth();
            byte[] byArray = this.resample(originalBufferedImage, width, (int)((float)originalBufferedImage.getHeight() * newYRatio), resamplingAlgorithm, ImagingUtil.getType(image));
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not resample image by width.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] resampleByHeight(byte[] image, int height, ResamplingAlgorithm resamplingAlgorithm) {
        try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
            BufferedImage originalBufferedImage = ImageIO.read(originalImageInputStream);
            float newXRatio = (float)height / (float)originalBufferedImage.getHeight();
            byte[] byArray = this.resample(originalBufferedImage, (int)((float)originalBufferedImage.getWidth() * newXRatio), height, resamplingAlgorithm, ImagingUtil.getType(image));
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not resample image by height.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] resample(byte[] image, int width, int height, ResamplingAlgorithm resamplingAlgorithm) {
        try (ByteArrayInputStream originalImageInputStream = new ByteArrayInputStream(image);){
            BufferedImage originalBufferedImage = ImageIO.read(originalImageInputStream);
            byte[] byArray = this.resample(originalBufferedImage, width, height, resamplingAlgorithm, ImagingUtil.getType(image));
            return byArray;
        }
        catch (IOException e) {
            throw new QImagingException("Could not resample image.", (Throwable)e);
        }
    }
}

