/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.fuse.imaging.impl.util;

import com.eurodyn.qlack2.fuse.imaging.api.dto.DotsPerInch;
import com.eurodyn.qlack2.fuse.imaging.api.exception.QImagingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImagingUtil {
    private ImagingUtil() {
    }

    public static DotsPerInch getDPI(byte[] image) throws IOException {
        DotsPerInch dotsPerInch = null;
        try (ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(image));){
            Node item;
            NamedNodeMap nnm;
            Iterator<ImageReader> it = ImageIO.getImageReaders(stream);
            if (!it.hasNext()) {
                throw new QImagingException("Could not find a reader for the image.");
            }
            ImageReader reader = it.next();
            reader.setInput(stream);
            IIOMetadata meta = reader.getImageMetadata(0);
            IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree("javax_imageio_1.0");
            NodeList nodes = root.getElementsByTagName("HorizontalPixelSize");
            dotsPerInch = new DotsPerInch();
            if (nodes.getLength() > 0) {
                IIOMetadataNode dpcWidth = (IIOMetadataNode)nodes.item(0);
                nnm = dpcWidth.getAttributes();
                item = nnm.item(0);
                int xDPI = Math.round(25.4f / Float.parseFloat(item.getNodeValue()));
                dotsPerInch.setHorizontal(xDPI);
            } else {
                dotsPerInch.setHorizontal(0);
            }
            if (nodes.getLength() > 0) {
                nodes = root.getElementsByTagName("VerticalPixelSize");
                IIOMetadataNode dpcHeight = (IIOMetadataNode)nodes.item(0);
                nnm = dpcHeight.getAttributes();
                item = nnm.item(0);
                int yDPI = Math.round(25.4f / Float.parseFloat(item.getNodeValue()));
                dotsPerInch.setVertical(yDPI);
            } else {
                dotsPerInch.setVertical(0);
            }
        }
        return dotsPerInch;
    }

    public static String getType(byte[] image) throws IOException {
        String type = null;
        ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(image));
        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
        if (readers.hasNext()) {
            type = readers.next().getFormatName();
        }
        return type;
    }
}

