/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.fuse.imaging.impl;

import com.eurodyn.qlack2.fuse.imaging.api.QRCodeService;
import com.eurodyn.qlack2.fuse.imaging.api.exception.QImagingException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.inject.Singleton;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;

@Singleton
@OsgiServiceProvider(classes={QRCodeService.class})
public class QRCodeServiceImpl
implements QRCodeService {
    public static final int DEFAULT_WIDTH = 125;
    public static final int DEFAULT_HEIGHT = 125;
    public static final String DEFAULT_FORMAT = "PNG";
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;

    public byte[] generateQRCode(String text) {
        return this.generateQRCode(text, 125, 125, DEFAULT_FORMAT, DEFAULT_BACKGROUND, DEFAULT_FOREGROUND);
    }

    public byte[] generateQRCode(String text, int width, int height, String imageFormat, Color background, Color foreground) {
        byte[] qrCode = null;
        try {
            HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, hintMap);
            int matrixWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(matrixWidth, matrixWidth, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(background);
            graphics.fillRect(0, 0, matrixWidth, matrixWidth);
            graphics.setColor(foreground);
            for (int i = 0; i < matrixWidth; ++i) {
                for (int j = 0; j < matrixWidth; ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    graphics.fillRect(i, j, 1, 1);
                }
            }
            try (ByteArrayOutputStream dstImage = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, imageFormat, dstImage);
                qrCode = dstImage.toByteArray();
            }
        }
        catch (WriterException | IOException e) {
            throw new QImagingException("Could not generate QR code.", e);
        }
        return qrCode;
    }
}

