/*
 * Decompiled with CFR 0.152.
 */
package com.eurodyn.qlack2.fuse.imaging.impl.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class FileReader {
    private static int defaultBinaryFileBufferSize = 8192;

    public static byte[] readBinaryFile(String filename) throws Exception {
        return FileReader.readBinaryFile(new File(filename));
    }

    public static byte[] readBinaryFile(File file) throws Exception {
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new Exception("Unsupported file size [" + fileSize + "]");
        }
        byte[] retVal = new byte[(int)fileSize];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        int readFileSize = ((InputStream)in).read(retVal, 0, (int)fileSize);
        ((InputStream)in).close();
        if ((long)readFileSize != fileSize) {
            throw new Exception("Incomplete file read [filesize=" + fileSize + ", read=" + readFileSize);
        }
        return retVal;
    }

    public static Properties loadProperties(Class clazz, String fileName) throws Exception {
        Properties properties = new Properties();
        InputStream inputStream = clazz.getResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = clazz.getClassLoader().getResourceAsStream(fileName);
        }
        properties.load(inputStream);
        return properties;
    }
}

