/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal;

import com.ethlo.time.Field;
import java.time.format.DateTimeParseException;

public class ErrorUtil {
    private ErrorUtil() {
    }

    public static DateTimeParseException raiseUnexpectedCharacter(String chars, int index) {
        throw new DateTimeParseException(String.format("Unexpected character %s at position %d: %s", Character.valueOf(chars.charAt(index)), index + 1, chars), chars, index);
    }

    public static DateTimeParseException raiseUnexpectedEndOfText(String chars, int offset) {
        throw new DateTimeParseException(String.format("Unexpected end of input: %s", chars), chars, offset);
    }

    public static DateTimeParseException raiseMissingGranularity(Field field, String chars, int offset) {
        throw new DateTimeParseException(String.format("Unexpected end of input, missing field %s: %s", field.name(), chars), chars, offset);
    }

    public static void assertPositionContains(Field field, String chars, int index, char expected) {
        if (index >= chars.length()) {
            throw ErrorUtil.raiseMissingGranularity(field, chars, index);
        }
        if (chars.charAt(index) != expected) {
            throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", Character.valueOf(expected), index + 1, Character.valueOf(chars.charAt(index)), chars), chars, index);
        }
    }

    public static void assertFractionDigits(String chars, int fractionDigits, int idx) {
        if (fractionDigits == 0) {
            throw new DateTimeParseException(String.format("Must have at least 1 fraction digit: %s", chars), chars, idx);
        }
        if (fractionDigits > 9) {
            throw new DateTimeParseException(String.format("Maximum supported number of fraction digits in second is 9, got %d: %s", fractionDigits, chars), chars, idx);
        }
    }
}

