/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.DateTime;
import com.ethlo.time.EthloITU;
import com.ethlo.time.Field;
import com.ethlo.time.TemporalConsumer;
import com.ethlo.time.TemporalHandler;
import com.ethlo.time.TemporalType;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;

public class ITU {
    private static final EthloITU delegate = EthloITU.getInstance();

    private ITU() {
    }

    public static OffsetDateTime parseDateTime(String s) {
        return delegate.parseDateTime(s);
    }

    public static DateTime parseLenient(String text) {
        return delegate.parse(text);
    }

    public static boolean isValid(String dateTime) {
        try {
            ITU.parseDateTime(dateTime);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    public static String formatUtc(OffsetDateTime date, int fractionDigits) {
        return delegate.formatUtc(date, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime date, Field lastIncluded) {
        return delegate.formatUtc(date, lastIncluded);
    }

    public static String formatUtc(OffsetDateTime date) {
        return delegate.formatUtc(date);
    }

    public static String formatUtcMilli(OffsetDateTime date) {
        return delegate.formatUtcMilli(date);
    }

    public static String formatUtcMicro(OffsetDateTime date) {
        return delegate.formatUtcMicro(date);
    }

    public static String formatUtcNano(OffsetDateTime date) {
        return delegate.formatUtcNano(date);
    }

    public static void parse(String text, TemporalConsumer temporalConsumer) {
        DateTime dateTime = delegate.parse(text);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                temporalConsumer.handle(dateTime.toOffsetDatetime());
            } else {
                temporalConsumer.handle(dateTime.toLocalDatetime());
            }
        } else if (dateTime.includesGranularity(Field.DAY)) {
            temporalConsumer.handle(dateTime.toLocalDate());
        } else if (dateTime.includesGranularity(Field.MONTH)) {
            temporalConsumer.handle(dateTime.toYearMonth());
        } else {
            temporalConsumer.handle(Year.of(dateTime.getYear()));
        }
    }

    public static <T> T parse(String text, TemporalHandler<T> temporalHandler) {
        DateTime dateTime = delegate.parse(text);
        if (dateTime.includesGranularity(Field.MINUTE)) {
            if (dateTime.getOffset().isPresent()) {
                return temporalHandler.handle(dateTime.toOffsetDatetime());
            }
            return temporalHandler.handle(dateTime.toLocalDatetime());
        }
        if (dateTime.includesGranularity(Field.DAY)) {
            return temporalHandler.handle(dateTime.toLocalDate());
        }
        if (dateTime.includesGranularity(Field.MONTH)) {
            return temporalHandler.handle(dateTime.toYearMonth());
        }
        return temporalHandler.handle(Year.of(dateTime.getYear()));
    }

    public static boolean isValid(String text, final TemporalType ... types) {
        try {
            return ITU.parse(text, new TemporalHandler<Boolean>(){

                @Override
                public Boolean handle(LocalDate localDate) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE, types);
                }

                @Override
                public Boolean handle(OffsetDateTime offsetDateTime) {
                    return ITU.isAllowed(TemporalType.OFFSET_DATE_TIME, types);
                }

                @Override
                public Boolean handle(LocalDateTime localDateTime) {
                    return ITU.isAllowed(TemporalType.LOCAL_DATE_TIME, types);
                }

                @Override
                public Boolean handle(YearMonth yearMonth) {
                    return ITU.isAllowed(TemporalType.YEAR_MONTH, types);
                }

                @Override
                public Boolean handle(Year year) {
                    return ITU.isAllowed(TemporalType.YEAR, types);
                }
            });
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    private static void assertIsAllowed(TemporalType needle, TemporalType ... allowed) {
        if (!ITU.isAllowed(needle, allowed)) {
            throw new DateTimeException("Is not a valid representation of " + (Object)((Object)needle));
        }
    }

    private static boolean isAllowed(TemporalType needle, TemporalType ... allowed) {
        for (TemporalType t : allowed) {
            if (!t.equals((Object)needle)) continue;
            return true;
        }
        return false;
    }
}

