/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.DateTime;
import com.ethlo.time.EthloITU;
import com.ethlo.time.Field;
import java.time.DateTimeException;
import java.time.OffsetDateTime;

public class ITU {
    private static final EthloITU delegate = EthloITU.getInstance();

    private ITU() {
    }

    public static OffsetDateTime parseDateTime(String s) {
        return delegate.parseDateTime(s);
    }

    public static DateTime parseLenient(String text) {
        return delegate.parse(text);
    }

    public static boolean isValid(String dateTime) {
        try {
            ITU.parseDateTime(dateTime);
            return true;
        }
        catch (DateTimeException exc) {
            return false;
        }
    }

    public static String formatUtc(OffsetDateTime date, int fractionDigits) {
        return delegate.formatUtc(date, fractionDigits);
    }

    public static String formatUtc(OffsetDateTime date, Field lastIncluded) {
        return delegate.formatUtc(date, lastIncluded);
    }

    public static String formatUtc(OffsetDateTime date) {
        return delegate.formatUtc(date);
    }

    public static String formatUtcMilli(OffsetDateTime date) {
        return delegate.formatUtcMilli(date);
    }

    public static String formatUtcMicro(OffsetDateTime date) {
        return delegate.formatUtcMicro(date);
    }

    public static String formatUtcNano(OffsetDateTime date) {
        return delegate.formatUtcNano(date);
    }
}

