/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.AbstractRfc3339;
import com.ethlo.time.DateTime;
import com.ethlo.time.DefaultLeapSecondHandler;
import com.ethlo.time.FastUTCZoneId;
import com.ethlo.time.Field;
import com.ethlo.time.JdkRfc3339;
import com.ethlo.time.LeapSecondException;
import com.ethlo.time.LeapSecondHandler;
import com.ethlo.time.LimitedCharArrayIntegerUtil;
import com.ethlo.time.TimezoneOffset;
import com.ethlo.time.W3cDateTimeUtil;
import java.time.DateTimeException;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;

public class EthloITU
extends AbstractRfc3339
implements W3cDateTimeUtil {
    private static final EthloITU instance = new EthloITU();
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char DATE_SEPARATOR = '-';
    private static final char TIME_SEPARATOR = ':';
    private static final char SEPARATOR_UPPER = 'T';
    private static final char SEPARATOR_LOWER = 't';
    private static final char SEPARATOR_SPACE = ' ';
    private static final char FRACTION_SEPARATOR = '.';
    private static final char ZULU_UPPER = 'Z';
    private static final char ZULU_LOWER = 'z';
    private static final int[] widths = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private final JdkRfc3339 delegate = new JdkRfc3339();
    private final LeapSecondHandler leapSecondHandler = new DefaultLeapSecondHandler();

    private EthloITU() {
    }

    public static EthloITU getInstance() {
        return instance;
    }

    private int getHour(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 11, 13);
    }

    private int getMinute(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 14, 16);
    }

    private int getDay(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 8, 10);
    }

    private DateTime handleTime(char[] chars, int year, int month, int day, int hour, int minute) {
        switch (chars[16]) {
            case ':': {
                return this.handleSeconds(year, month, day, hour, minute, chars);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                TimezoneOffset zoneOffset = this.parseTimezone(chars, 16);
                return DateTime.of(year, month, day, hour, minute, zoneOffset);
            }
        }
        this.assertPositionContains(chars, 16, ':', '+', '-', 'Z');
        throw new DateTimeException(new String(chars));
    }

    private void assertPositionContains(char[] chars, int offset, char expected) {
        if (offset >= chars.length) {
            this.raiseDateTimeException(chars, "Unexpected end of input");
        }
        if (chars[offset] != expected) {
            throw new DateTimeException("Expected character " + expected + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private void assertPositionContains(char[] chars, int offset, char ... expected) {
        if (offset >= chars.length) {
            this.raiseDateTimeException(chars, "Unexpected end of input");
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new DateTimeException("Expected character " + Arrays.toString(expected) + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private TimezoneOffset parseTimezone(char[] chars, int offset) {
        int len = chars.length;
        int left = len - offset;
        char c = chars[offset];
        if (c == 'Z' || c == 'z') {
            this.assertNoMoreChars(chars, offset);
            return TimezoneOffset.UTC;
        }
        if (left != 6) {
            throw new DateTimeException("Invalid timezone offset: " + new String(chars, offset, left));
        }
        char sign = chars[offset];
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 1, offset + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 4, offset + 4 + 2);
        if (sign == '-') {
            hours = -hours;
        } else if (sign != '+') {
            throw new DateTimeException("Invalid character starting at position " + offset + 1);
        }
        if (sign == '-' && hours == 0 && minutes == 0) {
            throw new DateTimeException("Unknown 'Local Offset Convention' date-time not allowed");
        }
        return TimezoneOffset.ofHoursMinutes(hours, minutes);
    }

    private void assertNoMoreChars(char[] chars, int lastUsed) {
        if (chars.length > lastUsed + 1) {
            throw new DateTimeException("Trailing junk data after position " + (lastUsed + 1) + ": " + new String(chars));
        }
    }

    @Override
    public String formatUtc(OffsetDateTime date, int fractionDigits) {
        return this.doFormatUtc(date, Field.SECOND, fractionDigits);
    }

    @Override
    public String formatUtc(OffsetDateTime date, Field lastIncluded) {
        return this.doFormatUtc(date, lastIncluded, 0);
    }

    private String doFormatUtc(OffsetDateTime date, Field lastIncluded, int fractionDigits) {
        boolean hasFractionDigits;
        char[] buffer;
        this.assertMaxFractionDigits(fractionDigits);
        OffsetDateTime utc = date;
        if (date.getOffset() != ZoneOffset.UTC) {
            utc = date.atZoneSameInstant(FastUTCZoneId.get()).toOffsetDateTime();
        }
        if (this.handleDatePart(lastIncluded, buffer = new char[31], utc.getYear(), 0, 4, Field.YEAR)) {
            return this.finish(buffer, Field.YEAR.getRequiredLength());
        }
        buffer[4] = 45;
        if (this.handleDatePart(lastIncluded, buffer, utc.getMonthValue(), 5, 2, Field.MONTH)) {
            return this.finish(buffer, Field.MONTH.getRequiredLength());
        }
        buffer[7] = 45;
        if (this.handleDatePart(lastIncluded, buffer, utc.getDayOfMonth(), 8, 2, Field.DAY)) {
            return this.finish(buffer, Field.DAY.getRequiredLength());
        }
        buffer[10] = 84;
        LimitedCharArrayIntegerUtil.toString(utc.getHour(), buffer, 11, 2);
        buffer[13] = 58;
        if (this.handleDatePart(lastIncluded, buffer, utc.getMinute(), 14, 2, Field.MINUTE)) {
            return this.finish(buffer, Field.MINUTE.getRequiredLength());
        }
        buffer[16] = 58;
        LimitedCharArrayIntegerUtil.toString(utc.getSecond(), buffer, 17, 2);
        boolean bl = hasFractionDigits = fractionDigits > 0;
        if (hasFractionDigits) {
            buffer[19] = 46;
            this.addFractions(buffer, fractionDigits, utc.getNano());
        }
        int length = this.addUtcTimezone(fractionDigits, buffer, hasFractionDigits);
        return this.finish(buffer, length);
    }

    private int addUtcTimezone(int fractionDigits, char[] buf, boolean hasFractionDigits) {
        buf[hasFractionDigits ? 20 + fractionDigits : 19] = 90;
        return hasFractionDigits ? 21 + fractionDigits : 20;
    }

    private boolean handleDatePart(Field lastIncluded, char[] buffer, int value, int offset, int length, Field field) {
        LimitedCharArrayIntegerUtil.toString(value, buffer, offset, length);
        return lastIncluded == field;
    }

    private String finish(char[] buf, int length) {
        return new String(buf, 0, length);
    }

    private void addFractions(char[] buf, int fractionDigits, int nano) {
        double d = widths[fractionDigits - 1];
        LimitedCharArrayIntegerUtil.toString((int)((double)nano / d), buf, 20, fractionDigits);
    }

    @Override
    public String formatUtc(Date date) {
        return this.formatUtc(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC), 3);
    }

    @Override
    public String format(Date date, String timezone) {
        return this.delegate.format(date, timezone);
    }

    @Override
    public OffsetDateTime parseDateTime(String dateTime) {
        return this.parse(dateTime).assertMinGranularity(Field.SECOND).toOffsetDatetime();
    }

    @Override
    public String formatUtcMilli(OffsetDateTime date) {
        return this.formatUtc(date, 3);
    }

    @Override
    public String formatUtcMicro(OffsetDateTime date) {
        return this.formatUtc(date, 6);
    }

    @Override
    public String formatUtcNano(OffsetDateTime date) {
        return this.formatUtc(date, 9);
    }

    @Override
    public String formatUtc(OffsetDateTime date) {
        return this.formatUtc(date, 0);
    }

    @Override
    public String formatUtcMilli(Date date) {
        return this.formatUtcMilli(OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
    }

    @Override
    public String format(Date date, String timezone, int fractionDigits) {
        return this.delegate.format(date, timezone, fractionDigits);
    }

    @Override
    public DateTime parse(String text) {
        if (text == null) {
            throw new NullPointerException("text cannot be null");
        }
        int len = text.length();
        char[] chars = text.toCharArray();
        int years = this.getYear(chars);
        if (4 == len) {
            return DateTime.ofYear(years);
        }
        this.assertPositionContains(chars, 4, '-');
        int months = this.getMonth(chars);
        if (7 == len) {
            return DateTime.ofYearMonth(years, months);
        }
        this.assertPositionContains(chars, 7, '-');
        int days = this.getDay(chars);
        if (10 == len) {
            return DateTime.ofDate(years, months, days);
        }
        this.assertPositionContains(chars, 10, 'T', 't', ' ');
        int hours = this.getHour(chars);
        this.assertPositionContains(chars, 13, ':');
        int minutes = this.getMinute(chars);
        if (16 == len) {
            return DateTime.of(years, months, days, hours, minutes, null);
        }
        return this.handleTime(chars, years, months, days, hours, minutes);
    }

    private int getMonth(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 5, 7);
    }

    private int getYear(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 0, 4);
    }

    private DateTime handleSeconds(int year, int month, int day, int hour, int minute, char[] chars) {
        int remaining = chars.length - 19;
        if (remaining == 0) {
            int seconds = this.getSeconds(chars);
            return this.leapSecondCheck(year, month, day, hour, minute, seconds, 0, null);
        }
        TimezoneOffset offset = null;
        int fractions = 0;
        char c = chars[19];
        if (remaining == 1 && (c == 'Z' || c == 'z')) {
            offset = TimezoneOffset.UTC;
            this.assertNoMoreChars(chars, 19);
        } else if (remaining >= 1 && c == '.') {
            int idx = LimitedCharArrayIntegerUtil.indexOfNonDigit(chars, 20);
            if (idx != -1) {
                int len = idx - 20;
                fractions = this.getFractions(chars, idx, len);
                offset = this.parseTimezone(chars, idx);
            } else {
                this.raiseDateTimeException(chars, "No timezone information");
            }
        } else if (remaining >= 1 && (c == '+' || c == '-')) {
            offset = this.parseTimezone(chars, 19);
        } else {
            this.raiseDateTimeException(chars, "Unexpected character at position 19");
        }
        return this.leapSecondCheck(year, month, day, hour, minute, this.getSeconds(chars), fractions, offset);
    }

    private DateTime leapSecondCheck(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset) {
        YearMonth needle;
        boolean isValidLeapYearMonth;
        if (second == 60 && ((isValidLeapYearMonth = this.leapSecondHandler.isValidLeapSecondDate(needle = YearMonth.of(year, month))) || needle.isAfter(this.leapSecondHandler.getLastKnownLeapSecond()))) {
            int utcHour = hour - offset.getTotalSeconds() / 3600;
            int utcMinute = minute - offset.getTotalSeconds() % 3600 / 60;
            if ((month == Month.DECEMBER.getValue() && day == 31 || month == Month.JUNE.getValue() && day == 30) && utcHour == 23 && utcMinute == 59) {
                throw new LeapSecondException(OffsetDateTime.of(year, month, day, hour, minute, 59, nanos, offset.asJavaTimeOffset()).plusSeconds(1L), second, isValidLeapYearMonth);
            }
        }
        return DateTime.of(year, month, day, hour, minute, second, nanos, offset);
    }

    private void raiseDateTimeException(char[] chars, String message) {
        throw new DateTimeException(message + ": " + new String(chars));
    }

    private int getSeconds(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 17, 19);
    }

    private int getFractions(char[] chars, int idx, int len) {
        int fractions = LimitedCharArrayIntegerUtil.uncheckedParsePositiveInt(chars, 20, idx);
        switch (len) {
            case 1: {
                return fractions * 100000000;
            }
            case 2: {
                return fractions * 10000000;
            }
            case 3: {
                return fractions * 1000000;
            }
            case 4: {
                return fractions * 100000;
            }
            case 5: {
                return fractions * 10000;
            }
            case 6: {
                return fractions * 1000;
            }
            case 7: {
                return fractions * 100;
            }
            case 8: {
                return fractions * 10;
            }
        }
        return fractions;
    }
}

