/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.BluetoothLeScanner;
import com.estimote.scanning_sdk.packet_provider.scanner.AlwaysErrorEstimoteScaner;
import com.estimote.scanning_sdk.packet_provider.scanner.BluetoothLeScannerProvider;
import com.estimote.scanning_sdk.packet_provider.scanner.PostLollipopEstimoteScanner;
import com.estimote.scanning_sdk.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.HardwareFilterBuilderFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ServicesUuidConfig;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToConfigurableDeviceFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToEddystoneFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToEstimoteLocationFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToEstimoteMeshFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToEstimoteTelemetryFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToIBeaconFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToMirrorFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToNearableFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.ToUwbFilterTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.DefaultScanSettingsTransformer;
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.SamsungScanSettingsTransformer;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0003J\b\u0010\r\u001a\u00020\u0006H\u0003J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0003J\f\u0010\u0010\u001a\u00020\u0011*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScannerFactory;", "Lcom/estimote/scanning_sdk/packet_provider/scanner/ScannerFactory;", "bluetoothLeScannerProvider", "Lcom/estimote/scanning_sdk/packet_provider/scanner/BluetoothLeScannerProvider;", "(Lcom/estimote/scanning_sdk/packet_provider/scanner/BluetoothLeScannerProvider;)V", "create", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "androidVersion", "", "manufacturerId", "", "createDefaultScanFiltersTransformer", "Lcom/estimote/scanning_sdk/packet_provider/scanner/filter_transformers/DefaultScanFiltersTransformer;", "createPostLollipopDefaultScanner", "createPostLollipopScanner", "createPostLollipopScannerForSamsungDevices", "isSamsungDevice", "", "scanning-sdk_release"})
public final class EstimoteScannerFactory
implements ScannerFactory {
    private final BluetoothLeScannerProvider bluetoothLeScannerProvider;

    @Override
    @NotNull
    public EstimoteScanner create(int androidVersion, @NotNull String manufacturerId) {
        EstimoteScanner estimoteScanner;
        Intrinsics.checkParameterIsNotNull((Object)manufacturerId, (String)"manufacturerId");
        switch (androidVersion) {
            case 19: {
                estimoteScanner = new AlwaysErrorEstimoteScaner("Unable to start scanner on KitKat Android version");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                estimoteScanner = this.createPostLollipopScanner(manufacturerId);
                break;
            }
            default: {
                estimoteScanner = new AlwaysErrorEstimoteScaner("Unable to start scanner on this Android version (" + androidVersion + ')');
            }
        }
        return estimoteScanner;
    }

    private final EstimoteScanner createPostLollipopScanner(String manufacturerId) {
        return this.isSamsungDevice(manufacturerId) ? this.createPostLollipopScannerForSamsungDevices() : this.createPostLollipopDefaultScanner();
    }

    @TargetApi(value=24)
    private final EstimoteScanner createPostLollipopDefaultScanner() {
        EstimoteScanner estimoteScanner;
        BluetoothLeScanner bluetoothLeScanner = this.bluetoothLeScannerProvider.createLeScanner();
        if (bluetoothLeScanner != null) {
            BluetoothLeScanner bluetoothLeScanner2;
            BluetoothLeScanner scanner = bluetoothLeScanner2 = bluetoothLeScanner;
            estimoteScanner = new PostLollipopEstimoteScanner(scanner, new DefaultScanSettingsTransformer(), this.createDefaultScanFiltersTransformer());
        } else {
            estimoteScanner = new AlwaysErrorEstimoteScaner("Unable to create bluetooth LE scanner instance");
        }
        return estimoteScanner;
    }

    @TargetApi(value=24)
    private final EstimoteScanner createPostLollipopScannerForSamsungDevices() {
        EstimoteScanner estimoteScanner;
        BluetoothLeScanner bluetoothLeScanner = this.bluetoothLeScannerProvider.createLeScanner();
        if (bluetoothLeScanner != null) {
            BluetoothLeScanner bluetoothLeScanner2;
            BluetoothLeScanner scanner = bluetoothLeScanner2 = bluetoothLeScanner;
            estimoteScanner = new PostLollipopEstimoteScanner(scanner, new SamsungScanSettingsTransformer(), this.createDefaultScanFiltersTransformer());
        } else {
            estimoteScanner = new AlwaysErrorEstimoteScaner("Unable to create bluetooth LE scanner instance");
        }
        return estimoteScanner;
    }

    @TargetApi(value=24)
    private final DefaultScanFiltersTransformer createDefaultScanFiltersTransformer() {
        return new DefaultScanFiltersTransformer(new ToIBeaconFilterTransformer(new HardwareFilterBuilderFactory()), new ToEddystoneFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToEstimoteTelemetryFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToEstimoteLocationFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToEstimoteMeshFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToMirrorFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToUwbFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToNearableFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()), new ToConfigurableDeviceFilterTransformer(new HardwareFilterBuilderFactory(), new ServicesUuidConfig()));
    }

    private final boolean isSamsungDevice(@NotNull String $receiver) {
        return StringsKt.equals((String)$receiver, (String)"samsung", (boolean)true);
    }

    public EstimoteScannerFactory(@NotNull BluetoothLeScannerProvider bluetoothLeScannerProvider) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScannerProvider, (String)"bluetoothLeScannerProvider");
        this.bluetoothLeScannerProvider = bluetoothLeScannerProvider;
    }
}

