package com.estimote.scanning_sdk.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.EstimoteTelemetryFrameBPacket
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_sdk.settings.EstimoteTelemetryScanSettings
import io.reactivex.Observable

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */
internal class EstimoteTelemetryBV1ScanUseCase(private val estimoteScanner: EstimoteScanner,
                                               private val recognizer: EstimoteScanResultRecognizer,
                                               private val parser: EstimoteScanResultParser<EstimoteTelemetryFrameBPacket>,
                                               private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: EstimoteTelemetryScanSettings): Observable<EstimoteTelemetryFrameBPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteTelemetryFrameBPacket.smoothRssi(): EstimoteTelemetryFrameBPacket {
        val smoother = rssiSmootherCache.get( shortId )
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}