package com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_sdk.settings.EstimoteLocationScanSettings


@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEstimoteLocationFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): DefaultScanFiltersTransformer.ScanFilterTransformer<EstimoteLocationScanSettings> {
    private val LOCATION_FRAME_TYPE_DATA = byteArrayOf(0x01)
    private val LOCATION_FRAME_TYPE_MASK = byteArrayOf(0x0F)

    override fun transform(settings: EstimoteLocationScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setServiceData(servicesUuidConfig.estimoteUUID, LOCATION_FRAME_TYPE_DATA, LOCATION_FRAME_TYPE_MASK)
                .build())
    }
}