package com.estimote.scanning_sdk.dagger

import com.estimote.scanning_sdk.api.EstimoteBluetoothScannerFactory
import com.estimote.scanning_sdk.packet_provider.service.PacketProviderWrapperService
import dagger.Component

@EstimoteScanningSdkScope
@Component(modules = arrayOf(
        EstimoteScanningSdkModule::class,
        BluetoothModule::class,
        ScannerModule::class,
        UseCaseModule::class,
        PacketProviderModule::class))
internal interface EstimoteScanningSdkComponent {
    fun inject(bluetoothScannerFactory: EstimoteBluetoothScannerFactory)
    fun inject(packetProviderWrapperService: PacketProviderWrapperService)
}