package com.estimote.scanning_sdk.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EstimoteMirror
import com.estimote.internal_plugins_api.scanning.EstimoteUwb
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import com.estimote.scanning_sdk.settings.MirrorScanSettings
import com.estimote.scanning_sdk.settings.UwbScanSettings

/**
 * @author lukasz.pobereznik@estimote.com (Lukasz Pobereznik).
 */
internal class SimpleEstimoteMirrorScanLauncher(useCase: ScanUseCase<MirrorScanSettings, EstimoteMirror>) : BaseScanLauncher<MirrorScanSettings, EstimoteMirror, SimpleEstimoteMirrorScanLauncher>(useCase), BluetoothScanner.EstimoteMirrorScanLauncher {
    override val buildSettings: (SimpleEstimoteMirrorScanLauncher) -> MirrorScanSettings = { MirrorScanSettings(it.powerMode) }
}