/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.use_cases;

import android.annotation.TargetApi;
import com.estimote.scanning_sdk.packet_provider.BeaconPacket;
import com.estimote.scanning_sdk.packet_provider.antenna_bias.AntennaBiasCorrection;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_sdk.packet_provider.use_cases.ExpirationCache;
import com.estimote.scanning_sdk.settings.IBeaconScanSettings;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\f\u0010\u0014\u001a\u00020\b*\u00020\bH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/use_cases/IBeaconScanUseCase;", "", "estimoteScanner", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "recognizer", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultRecognizer;", "parser", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/BeaconPacket;", "rssiSmootherCache", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/ExpirationCache;", "", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/RssiSmoother;", "antennaBiasCorrection", "Lcom/estimote/scanning_sdk/packet_provider/antenna_bias/AntennaBiasCorrection;", "(Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultRecognizer;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;Lcom/estimote/scanning_sdk/packet_provider/use_cases/ExpirationCache;Lcom/estimote/scanning_sdk/packet_provider/antenna_bias/AntennaBiasCorrection;)V", "run", "Lio/reactivex/Observable;", "scanSettings", "Lcom/estimote/scanning_sdk/settings/IBeaconScanSettings;", "smoothRssiAndApplyAntennaBiasCorrection", "scanning-sdk_release"})
public final class IBeaconScanUseCase {
    private final EstimoteScanner estimoteScanner;
    private final EstimoteScanResultRecognizer recognizer;
    private final EstimoteScanResultParser<BeaconPacket> parser;
    private final ExpirationCache<String, RssiSmoother> rssiSmootherCache;
    private final AntennaBiasCorrection antennaBiasCorrection;

    @TargetApi(value=21)
    @NotNull
    public final Observable<BeaconPacket> run(@NotNull IBeaconScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = this.estimoteScanner.scan(scanSettings).filter((Predicate)new Predicate<EstimoteScanResult>(this){
            final /* synthetic */ IBeaconScanUseCase this$0;

            public final boolean test(@NotNull EstimoteScanResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return IBeaconScanUseCase.access$getRecognizer$p(this.this$0).recognize(it);
            }
            {
                this.this$0 = iBeaconScanUseCase;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ IBeaconScanUseCase this$0;

            @NotNull
            public final BeaconPacket apply(@NotNull EstimoteScanResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (BeaconPacket)IBeaconScanUseCase.access$getParser$p(this.this$0).parse(it);
            }
            {
                this.this$0 = iBeaconScanUseCase;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ IBeaconScanUseCase this$0;

            @NotNull
            public final BeaconPacket apply(@NotNull BeaconPacket it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return IBeaconScanUseCase.access$smoothRssiAndApplyAntennaBiasCorrection(this.this$0, it);
            }
            {
                this.this$0 = iBeaconScanUseCase;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"estimoteScanner.scan(sca\u2026AntennaBiasCorrection() }");
        return observable;
    }

    private final BeaconPacket smoothRssiAndApplyAntennaBiasCorrection(@NotNull BeaconPacket $receiver) {
        RssiSmoother smoother = this.rssiSmootherCache.get($receiver.getMacAddress().getAddress());
        double smoothedRssi = smoother.smooth($receiver.getRssi(), (double)$receiver.getTimestamp() / 1.0E9);
        long l = 0L;
        int n = $receiver.getMeasuredPower() + this.antennaBiasCorrection.getCorrection();
        int n2 = (int)smoothedRssi;
        return BeaconPacket.copy$default($receiver, null, 0, 0, null, n, n2, l, 79, null);
    }

    public IBeaconScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull EstimoteScanResultRecognizer recognizer, @NotNull EstimoteScanResultParser<BeaconPacket> parser, @NotNull ExpirationCache<? super String, RssiSmoother> rssiSmootherCache, @NotNull AntennaBiasCorrection antennaBiasCorrection) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)recognizer, (String)"recognizer");
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull(rssiSmootherCache, (String)"rssiSmootherCache");
        Intrinsics.checkParameterIsNotNull((Object)antennaBiasCorrection, (String)"antennaBiasCorrection");
        this.estimoteScanner = estimoteScanner;
        this.recognizer = recognizer;
        this.parser = parser;
        this.rssiSmootherCache = rssiSmootherCache;
        this.antennaBiasCorrection = antennaBiasCorrection;
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResultRecognizer access$getRecognizer$p(IBeaconScanUseCase $this) {
        return $this.recognizer;
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResultParser access$getParser$p(IBeaconScanUseCase $this) {
        return $this.parser;
    }

    @NotNull
    public static final /* synthetic */ BeaconPacket access$smoothRssiAndApplyAntennaBiasCorrection(IBeaconScanUseCase $this, @NotNull BeaconPacket $receiver) {
        return $this.smoothRssiAndApplyAntennaBiasCorrection($receiver);
    }
}

