/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.rssi_smoothers;

import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.ExpirationPolicy;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.Timer;
import com.estimote.scanning_sdk.packet_provider.use_cases.ExpirationCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u001d\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00010\r0\fX\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/TimeExpirationCache;", "KEY", "VALUE", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/ExpirationCache;", "timer", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/Timer;", "loader", "Lkotlin/Function1;", "expirationPolicy", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/ExpirationPolicy;", "(Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/Timer;Lkotlin/jvm/functions/Function1;Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/ExpirationPolicy;)V", "map", "", "Lkotlin/Pair;", "", "contains", "", "key", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "loadNewValueForKey", "put", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "removeExpiredValues", "updateTimestampForKey", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "scanning-sdk_release"})
public final class TimeExpirationCache<KEY, VALUE>
implements ExpirationCache<KEY, VALUE> {
    private final Map<KEY, Pair<Long, VALUE>> map;
    private final Timer timer;
    private final Function1<KEY, VALUE> loader;
    private final ExpirationPolicy expirationPolicy;

    @Override
    public VALUE get(KEY key) {
        this.removeExpiredValues();
        Pair<Long, VALUE> value = this.map.get(key);
        return (VALUE)(value == null || this.expirationPolicy.hasExpired(((Number)value.getFirst()).longValue()) ? this.loadNewValueForKey(key) : this.updateTimestampForKey(key, value.getSecond()));
    }

    private final VALUE loadNewValueForKey(KEY key) {
        Object newValue = this.loader.invoke(key);
        this.put(key, newValue);
        return (VALUE)newValue;
    }

    private final VALUE updateTimestampForKey(KEY key, VALUE value) {
        this.put(key, value);
        return value;
    }

    @Override
    public void put(KEY key, VALUE value) {
        this.map.put(key, TuplesKt.to((Object)this.timer.getCurrentTimeMillis(), value));
    }

    @Override
    public void removeExpiredValues() {
        Map<KEY, Pair<Long, VALUE>> map = this.map;
        Iterator<Map.Entry<KEY, Pair<Long, VALUE>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<KEY, Pair<Long, VALUE>> entry = iterator.next();
            if (!this.expirationPolicy.hasExpired(((Number)entry.getValue().getFirst()).longValue())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean contains(KEY key) {
        Map<KEY, Pair<Long, VALUE>> map;
        Map<KEY, Pair<Long, VALUE>> map2;
        Map<KEY, Pair<Long, VALUE>> map3 = map2 = (map = this.map);
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(key);
    }

    public TimeExpirationCache(@NotNull Timer timer, @NotNull Function1<? super KEY, ? extends VALUE> loader, @NotNull ExpirationPolicy expirationPolicy) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)expirationPolicy, (String)"expirationPolicy");
        this.timer = timer;
        this.loader = loader;
        this.expirationPolicy = expirationPolicy;
        TimeExpirationCache timeExpirationCache = this;
        timeExpirationCache.map = map = (Map)new LinkedHashMap();
    }
}

