/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteLocationPacket;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\u0007*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u0007*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\u0007*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteLocationV1Parser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteLocationPacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "decodeChannelValue", "", "value", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "getChannel", "Ljava/nio/ByteBuffer;", "getDeviceId", "", "getMeasuredPower", "getProtocolVersion", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteLocationV1Parser
implements EstimoteScanResultParser<EstimoteLocationPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteLocationPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = this.getDeviceId($receiver);
        int n = this.getChannel($receiver);
        int n2 = this.getProtocolVersion($receiver);
        int n3 = this.getMeasuredPower($receiver);
        String string2 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.device.address");
        return new EstimoteLocationPacket(string, n, n2, n3, new EstimoteMacAddress(string2), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] idBytes = new byte[16];
        $receiver.position(1);
        $receiver.get(idBytes, 0, 16);
        return ByteExtensionsKt.toHex(idBytes);
    }

    private final int getChannel(@NotNull ByteBuffer $receiver) {
        int channelValue = $receiver.get(18) & 3;
        return this.decodeChannelValue(channelValue);
    }

    private final int getMeasuredPower(@NotNull ByteBuffer $receiver) {
        return $receiver.get(17);
    }

    private final int getProtocolVersion(@NotNull ByteBuffer $receiver) {
        return ($receiver.get(0) & 0xF0) >> 4;
    }

    private final int decodeChannelValue(int value) {
        int n;
        switch (value) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 37;
                break;
            }
            case 2: {
                n = 38;
                break;
            }
            case 3: {
                n = 39;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Wrong estimote location channel value: " + value);
            }
        }
        return n;
    }
}

