/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.internal_plugins_api.scanning.DeviceType;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteConnectivityPacket;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0019H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteConnectivityParser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteConnectivityPacket;", "()V", "ESTIMOTE_MANUFACTURER_ID", "", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "emptyManufacturerDataBytes", "", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "getApplicationVersion", "", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "getBootloaderVersion", "getDeviceId", "getDeviceType", "Lcom/estimote/internal_plugins_api/scanning/DeviceType;", "getNearToConnect", "", "getShakeToConnect", "toVersionOctet", "", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteConnectivityParser
implements EstimoteScanResultParser<EstimoteConnectivityPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));
    private final int ESTIMOTE_MANUFACTURER_ID = 349;
    private final byte[] emptyManufacturerDataBytes = new byte[]{0, 0, 0, 0, 0, 0};

    @Override
    @NotNull
    public EstimoteConnectivityPacket parse(@NotNull EstimoteScanResult result) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer serviceData = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        byte[] byArray = result.getScanRecord().getManufacturerSpecificData(this.ESTIMOTE_MANUFACTURER_ID);
        if (byArray == null) {
            byArray = this.emptyManufacturerDataBytes;
        }
        ByteBuffer manufacturerSpecificData = ByteBuffer.wrap(byArray);
        Pair $receiver = pair = new Pair((Object)serviceData, (Object)manufacturerSpecificData);
        String string = this.getDeviceId((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        DeviceType deviceType = this.getDeviceType((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        String string2 = this.getBootloaderVersion((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        String string3 = this.getApplicationVersion((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        boolean bl = this.getShakeToConnect((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        boolean bl2 = this.getNearToConnect((Pair<? extends ByteBuffer, ? extends ByteBuffer>)$receiver);
        String string4 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"result.device.address");
        return new EstimoteConnectivityPacket(string, deviceType, string2, string3, bl, bl2, new EstimoteMacAddress(string4), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getDeviceId(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        byte[] bytes = new byte[16];
        ((ByteBuffer)$receiver.getFirst()).position(1);
        ((ByteBuffer)$receiver.getFirst()).get(bytes, 0, 16);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final DeviceType getDeviceType(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        return DeviceType.LOCATION_BEACON;
    }

    private final String getBootloaderVersion(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        byte[] bytes = new byte[2];
        ((ByteBuffer)$receiver.getFirst()).position(18);
        ((ByteBuffer)$receiver.getFirst()).get(bytes, 0, 2);
        return "" + this.toVersionOctet(bytes[1] >> 4) + '.' + this.toVersionOctet(bytes[1]) + '.' + this.toVersionOctet(bytes[0] >> 4);
    }

    private final String getApplicationVersion(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        byte[] bytes = new byte[2];
        ((ByteBuffer)$receiver.getFirst()).position(17);
        ((ByteBuffer)$receiver.getFirst()).get(bytes, 0, 2);
        return "" + this.toVersionOctet(bytes[1]) + '.' + this.toVersionOctet(bytes[0] >> 4) + '.' + this.toVersionOctet(bytes[0]);
    }

    private final boolean getShakeToConnect(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        byte by;
        byte by2 = ((ByteBuffer)$receiver.getSecond()).get(1);
        return (byte)(by2 & (by = 1)) > 0;
    }

    private final boolean getNearToConnect(@NotNull Pair<? extends ByteBuffer, ? extends ByteBuffer> $receiver) {
        int n;
        byte by = ((ByteBuffer)$receiver.getSecond()).get(1);
        return (byte)(by & (n = 2)) > 0;
    }

    private final String toVersionOctet(byte $receiver) {
        byte by = $receiver;
        int n = 15;
        return String.valueOf((byte)(by & n));
    }

    private final String toVersionOctet(int $receiver) {
        return String.valueOf($receiver & 0xF);
    }
}

