package com.estimote.scanning_sdk.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.EstimoteConnectivityPacket
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_sdk.settings.ConnectivityScanSettings
import io.reactivex.Observable

internal class EstimoteConnectivityScanUseCase(private val estimoteScanner: EstimoteScanner,
                                               private val recognizer: EstimoteScanResultRecognizer,
                                               private val parser: EstimoteScanResultParser<EstimoteConnectivityPacket>,
                                               private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: ConnectivityScanSettings): Observable<EstimoteConnectivityPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteConnectivityPacket.smoothRssi(): EstimoteConnectivityPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}