package com.estimote.scanning_sdk.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class IBeaconRecognizer: EstimoteScanResultRecognizer {
    private val APPLE_MANUFACTURER_ID = 0x004C
    private val MANUFACTURER_SPECIFIC_DATA_LENGTH = 23

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun recognize(result: EstimoteScanResult): Boolean {
        val scanRecord = result.scanRecord
        return (scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID) != null
                && scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID).size == MANUFACTURER_SPECIFIC_DATA_LENGTH
                && scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID)[0].toInt() == 0x02
                && scanRecord.getManufacturerSpecificData(APPLE_MANUFACTURER_ID)[1].toInt() == 0x15)
    }
}