/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteAcceleration;
import com.estimote.scanning_sdk.packet_provider.EstimoteGpio;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.EstimoteMotionDuration;
import com.estimote.scanning_sdk.packet_provider.EstimoteTelemetryFrameAPacket;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0017H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0017H\u0002J\f\u0010\u001d\u001a\u00020\t*\u00020\u0017H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteTelemetryAV0Parser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteTelemetryFrameAPacket;", "()V", "DEFAULT_PRESSURE_VALUE", "", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "getMotionDuration", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteMotionDuration;", "byte", "", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "recalculateIfCountedInWeeks", "", "value", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "transformToTimeUnit", "getAcceleration", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteAcceleration;", "Ljava/nio/ByteBuffer;", "getCurrentMotionDuration", "getGPIO", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteGpio;", "getMotionState", "", "getPreviousMotionDuration", "getShortIdentifier", "", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteTelemetryAV0Parser
implements EstimoteScanResultParser<EstimoteTelemetryFrameAPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));
    private final double DEFAULT_PRESSURE_VALUE = -1.0;

    @Override
    @NotNull
    public EstimoteTelemetryFrameAPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.address");
        return new EstimoteTelemetryFrameAPacket(new EstimoteMacAddress(string), result.getRssi(), result.getTimestampNanosSinceBoot(), this.getShortIdentifier($receiver), this.getAcceleration($receiver), this.getMotionState($receiver), this.getCurrentMotionDuration($receiver), this.getPreviousMotionDuration($receiver), this.getGPIO($receiver), this.DEFAULT_PRESSURE_VALUE);
    }

    private final String getShortIdentifier(@NotNull ByteBuffer $receiver) {
        byte[] shortIdBytes = new byte[8];
        $receiver.position(1);
        $receiver.get(shortIdBytes, 0, 8);
        return ByteExtensionsKt.toHex(shortIdBytes);
    }

    private final EstimoteAcceleration getAcceleration(@NotNull ByteBuffer $receiver) {
        double x = (double)$receiver.get(10) * 2.0 / 127.0;
        double y = (double)$receiver.get(11) * 2.0 / 127.0;
        double z = (double)$receiver.get(12) * 2.0 / 127.0;
        return new EstimoteAcceleration(x, y, z);
    }

    private final boolean getMotionState(@NotNull ByteBuffer $receiver) {
        byte by;
        byte by2 = $receiver.get(15);
        return (byte)(by2 & (by = (byte)3)) == 1;
    }

    private final EstimoteMotionDuration getMotionDuration(byte by) {
        byte by2 = by;
        byte by3 = (byte)63;
        int value = ByteExtensionsKt.toUnsignedInt((byte)(by2 & by3));
        by3 = by;
        byte by4 = (byte)192;
        int unitCode = ByteExtensionsKt.toUnsignedInt((byte)(by3 & by4)) >> 6;
        TimeUnit timeUnit = this.transformToTimeUnit(unitCode);
        int recalculatedValue = this.recalculateIfCountedInWeeks(value, timeUnit);
        return new EstimoteMotionDuration(recalculatedValue, timeUnit);
    }

    private final EstimoteMotionDuration getPreviousMotionDuration(@NotNull ByteBuffer $receiver) {
        return this.getMotionDuration($receiver.get(13));
    }

    private final EstimoteMotionDuration getCurrentMotionDuration(@NotNull ByteBuffer $receiver) {
        return this.getMotionDuration($receiver.get(14));
    }

    private final EstimoteGpio getGPIO(@NotNull ByteBuffer $receiver) {
        byte by;
        byte by2 = $receiver.get(15);
        boolean pin0 = ByteExtensionsKt.toUnsignedInt((byte)(by2 & (by = (byte)16))) >> 4 == 1;
        by = $receiver.get(15);
        byte by3 = (byte)32;
        boolean pin1 = ByteExtensionsKt.toUnsignedInt((byte)(by & by3)) >> 5 == 1;
        by3 = $receiver.get(15);
        byte by4 = (byte)64;
        boolean pin2 = ByteExtensionsKt.toUnsignedInt((byte)(by3 & by4)) >> 6 == 1;
        by4 = $receiver.get(15);
        byte by5 = (byte)128;
        boolean pin3 = ByteExtensionsKt.toUnsignedInt((byte)(by4 & by5)) >> 7 == 1;
        return new EstimoteGpio(pin0, pin1, pin2, pin3);
    }

    private final TimeUnit transformToTimeUnit(int value) {
        TimeUnit timeUnit;
        switch (value) {
            case 0: {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case 1: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 2: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 3: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                timeUnit = TimeUnit.MILLISECONDS;
            }
        }
        return timeUnit;
    }

    private final int recalculateIfCountedInWeeks(int value, TimeUnit timeUnit) {
        return Intrinsics.areEqual((Object)((Object)timeUnit), (Object)((Object)TimeUnit.DAYS)) && value > 31 ? 7 * value : value;
    }
}

