package com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_sdk.settings.EstimoteMeshScanSettings


@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEstimoteMeshFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): DefaultScanFiltersTransformer.ScanFilterTransformer<EstimoteMeshScanSettings> {
    private val MESH_FRAME_TYPE_DATA = byteArrayOf(0x05)
    private val MESH_FRAME_TYPE_MASK = byteArrayOf(0x0F)

    override fun transform(settings: EstimoteMeshScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setServiceData(servicesUuidConfig.estimoteUUID, MESH_FRAME_TYPE_DATA, MESH_FRAME_TYPE_MASK)
                .build())
    }
}