package com.estimote.scanning_sdk.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.Beacon
import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import com.estimote.scanning_sdk.settings.IBeaconScanSettings
import java.util.*

internal class SimpleBeaconScanLauncher(useCase: ScanUseCase<IBeaconScanSettings, Beacon>):
        BaseScanLauncher<IBeaconScanSettings, Beacon, SimpleBeaconScanLauncher>(useCase), BluetoothScanner.BeaconScanLauncher {
    internal var uuid: UUID? = null
    internal var major: Short? = null
    internal var minor: Short? = null

    override fun withUuid(uuid: UUID) = this.apply { this.uuid = uuid }
    override fun withMajor(major: Short) = this.apply { this.major = major }
    override fun withMinor(minor: Short) = this.apply { this.minor = minor }

    override val buildSettings: (SimpleBeaconScanLauncher) -> IBeaconScanSettings = { IBeaconScanSettings(it.powerMode, it.uuid, it.major, it.minor) }
}