package com.estimote.scanning_sdk.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import com.estimote.scanning_sdk.settings.EstimoteScanSettings
import java.util.concurrent.TimeUnit

internal abstract class BaseScanLauncher<SETTINGS_TYPE, PACKET_TYPE, LAUNCHER : BaseScanLauncher<SETTINGS_TYPE, PACKET_TYPE, LAUNCHER>>(
        internal val scanUseCase: ScanUseCase<SETTINGS_TYPE, PACKET_TYPE>) : BluetoothScanner.ScanLauncher<PACKET_TYPE> {
    internal var onErrorOccurred: (Throwable) -> Unit = {}
    internal var onPacketFound: (PACKET_TYPE) -> Unit = {}
    internal var powerMode = EstimoteScanSettings.ScanPowerMode.BALANCED
    internal var timeoutValue: Long = 0
    internal var timeoutUnit: TimeUnit = TimeUnit.SECONDS

    override fun withLowPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.LOW_POWER }
    override fun withBalancedPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.BALANCED }
    override fun withLowLatencyPowerMode() = this.apply { this.powerMode = EstimoteScanSettings.ScanPowerMode.LOW_LATENCY }
    override fun withOnPacketFoundAction(onPacketFound: (PACKET_TYPE) -> Unit) = this.apply { this.onPacketFound = onPacketFound }
    override fun withOnScanErrorAction(onErrorOccurred: (Throwable) -> Unit) = this.apply { this.onErrorOccurred = onErrorOccurred }
    override fun withTimeout(timeoutValue: Long, timeUnit: TimeUnit) = this.apply {
        this.timeoutValue = timeoutValue
        this.timeoutUnit = timeoutUnit
    }
    @Suppress("UNCHECKED_CAST") override fun start() = scanUseCase.run(timeoutValue, timeoutUnit, buildSettings(this as LAUNCHER), onPacketFound, onErrorOccurred)
    abstract val buildSettings: (LAUNCHER) -> SETTINGS_TYPE
}