/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.EstimoteMeshPacket;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\r\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u000bH\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\u0013H\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteMeshParser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteMeshPacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "getAppVersion", "", "Ljava/nio/ByteBuffer;", "getBootloaderVersion", "getDeviceId", "getMeshId", "", "getReportHash", "getSettingsVersion", "toVersionOctet", "", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteMeshParser
implements EstimoteScanResultParser<EstimoteMeshPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteMeshPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = this.getDeviceId($receiver);
        String string2 = this.getReportHash($receiver);
        int n = this.getMeshId($receiver);
        int n2 = this.getSettingsVersion($receiver);
        String string3 = this.getAppVersion($receiver);
        String string4 = this.getBootloaderVersion($receiver);
        String string5 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"result.device.address");
        return new EstimoteMeshPacket(string, string2, n, n2, string3, string4, new EstimoteMacAddress(string5), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(1);
        $receiver.get(bytes, 0, 4);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final String getReportHash(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(5);
        $receiver.get(bytes, 0, 4);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final int getMeshId(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(9);
        $receiver.get(bytes, 0, 4);
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private final int getSettingsVersion(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(13);
        $receiver.get(bytes, 0, 4);
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private final String getAppVersion(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(17);
        $receiver.get(bytes, 0, 2);
        return this.toVersionOctet(bytes[1]) + "." + this.toVersionOctet(bytes[0] >> 4) + "." + this.toVersionOctet(bytes[0]);
    }

    private final String getBootloaderVersion(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(18);
        $receiver.get(bytes, 0, 2);
        return this.toVersionOctet(bytes[1] >> 4) + "." + this.toVersionOctet(bytes[1]) + "." + this.toVersionOctet(bytes[0] >> 4);
    }

    private final String toVersionOctet(byte $receiver) {
        byte by = $receiver;
        int n = 15;
        return String.valueOf((byte)(by & n));
    }

    private final String toVersionOctet(int $receiver) {
        return String.valueOf($receiver & 0xF);
    }
}

