/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.dagger;

import android.bluetooth.le.BluetoothLeScanner;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkScope;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScannerFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import dagger.Module;
import dagger.Provides;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/estimote/scanning_sdk/dagger/ScannerModule;", "", "androidVersion", "", "manufacturerId", "", "(ILjava/lang/String;)V", "provideScanner", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "scannerFactory", "Lcom/estimote/scanning_sdk/packet_provider/scanner/ScannerFactory;", "provideScannerFactory", "bluetoothLeScanner", "Landroid/bluetooth/le/BluetoothLeScanner;", "scanning-sdk_release"})
public final class ScannerModule {
    private final int androidVersion;
    private final String manufacturerId;

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final ScannerFactory provideScannerFactory(@NotNull BluetoothLeScanner bluetoothLeScanner) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScanner, (String)"bluetoothLeScanner");
        return new EstimoteScannerFactory(bluetoothLeScanner);
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteScanner provideScanner(@NotNull ScannerFactory scannerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)scannerFactory, (String)"scannerFactory");
        return scannerFactory.create(this.androidVersion, this.manufacturerId);
    }

    public ScannerModule(int androidVersion, @NotNull String manufacturerId) {
        Intrinsics.checkParameterIsNotNull((Object)manufacturerId, (String)"manufacturerId");
        this.androidVersion = androidVersion;
        this.manufacturerId = manufacturerId;
    }
}

