/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.dagger;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import com.estimote.scanning_sdk.api.EstimoteBluetoothScannerFactory;
import com.estimote.scanning_sdk.api.EstimoteBluetoothScannerFactory_MembersInjector;
import com.estimote.scanning_sdk.dagger.BluetoothModule;
import com.estimote.scanning_sdk.dagger.BluetoothModule_ProvidesBluetoothAdapterFactory;
import com.estimote.scanning_sdk.dagger.BluetoothModule_ProvidesBluetoothLeScannerFactory;
import com.estimote.scanning_sdk.dagger.BluetoothModule_ProvidesBluetoothManagerFactory;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkComponent;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkModule;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkModule_ProvidePacketProviderServiceWrapperStarterFactory;
import com.estimote.scanning_sdk.dagger.PacketProviderModule;
import com.estimote.scanning_sdk.dagger.PacketProviderModule_ProvidesPacketProviderFactory;
import com.estimote.scanning_sdk.dagger.ScannerModule;
import com.estimote.scanning_sdk.dagger.ScannerModule_ProvideScannerFactory;
import com.estimote.scanning_sdk.dagger.ScannerModule_ProvideScannerFactoryFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEddystoneUidScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteConnectivityScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteLocationScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteMeshScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteMirrorScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteNearableScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideEstimoteUwbScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideIBeaconScanUseCaseFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideRssiExpirationCacheFactoryFactory;
import com.estimote.scanning_sdk.dagger.UseCaseModule_ProvideTimerFactory;
import com.estimote.scanning_sdk.packet_provider.PacketProvider;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmootherExpirationCacheFactory;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.Timer;
import com.estimote.scanning_sdk.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_sdk.packet_provider.service.PacketProviderWrapperService;
import com.estimote.scanning_sdk.packet_provider.service.PacketProviderWrapperServiceHelper;
import com.estimote.scanning_sdk.packet_provider.service.PacketProviderWrapperService_MembersInjector;
import com.estimote.scanning_sdk.packet_provider.use_cases.EddystoneUidScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteConnectivityScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteLocationScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteMeshScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteMirrorScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteNearableScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteUwbScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.IBeaconScanUseCase;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DaggerEstimoteScanningSdkComponent
implements EstimoteScanningSdkComponent {
    private Provider<BluetoothManager> providesBluetoothManagerProvider;
    private Provider<BluetoothAdapter> providesBluetoothAdapterProvider;
    private Provider<BluetoothLeScanner> providesBluetoothLeScannerProvider;
    private Provider<ScannerFactory> provideScannerFactoryProvider;
    private Provider<EstimoteScanner> provideScannerProvider;
    private Provider<Timer> provideTimerProvider;
    private Provider<RssiSmootherExpirationCacheFactory> provideRssiExpirationCacheFactoryProvider;
    private Provider<IBeaconScanUseCase> provideIBeaconScanUseCaseProvider;
    private Provider<EddystoneUidScanUseCase> provideEddystoneUidScanUseCaseProvider;
    private Provider<EstimoteLocationScanUseCase> provideEstimoteLocationScanUseCaseProvider;
    private Provider<EstimoteMeshScanUseCase> provideEstimoteMeshScanUseCaseProvider;
    private Provider<EstimoteConnectivityScanUseCase> provideEstimoteConnectivityScanUseCaseProvider;
    private Provider<EstimoteNearableScanUseCase> provideEstimoteNearableScanUseCaseProvider;
    private Provider<EstimoteUwbScanUseCase> provideEstimoteUwbScanUseCaseProvider;
    private Provider<EstimoteMirrorScanUseCase> provideEstimoteMirrorScanUseCaseProvider;
    private Provider<PacketProvider> providesPacketProvider;
    private Provider<PacketProviderWrapperServiceHelper> providePacketProviderServiceWrapperStarterProvider;
    private MembersInjector<EstimoteBluetoothScannerFactory> estimoteBluetoothScannerFactoryMembersInjector;
    private MembersInjector<PacketProviderWrapperService> packetProviderWrapperServiceMembersInjector;

    private DaggerEstimoteScanningSdkComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.providesBluetoothManagerProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothManagerFactory.create(builder.bluetoothModule));
        this.providesBluetoothAdapterProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothAdapterFactory.create(builder.bluetoothModule, this.providesBluetoothManagerProvider));
        this.providesBluetoothLeScannerProvider = DoubleCheck.provider(BluetoothModule_ProvidesBluetoothLeScannerFactory.create(builder.bluetoothModule, this.providesBluetoothAdapterProvider));
        this.provideScannerFactoryProvider = DoubleCheck.provider(ScannerModule_ProvideScannerFactoryFactory.create(builder.scannerModule, this.providesBluetoothLeScannerProvider));
        this.provideScannerProvider = DoubleCheck.provider(ScannerModule_ProvideScannerFactory.create(builder.scannerModule, this.provideScannerFactoryProvider));
        this.provideTimerProvider = DoubleCheck.provider(UseCaseModule_ProvideTimerFactory.create(builder.useCaseModule));
        this.provideRssiExpirationCacheFactoryProvider = DoubleCheck.provider(UseCaseModule_ProvideRssiExpirationCacheFactoryFactory.create(builder.useCaseModule, this.provideTimerProvider));
        this.provideIBeaconScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideIBeaconScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEddystoneUidScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEddystoneUidScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteLocationScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteLocationScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteMeshScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteMeshScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteConnectivityScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteConnectivityScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteNearableScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteNearableScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteUwbScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteUwbScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.provideEstimoteMirrorScanUseCaseProvider = DoubleCheck.provider(UseCaseModule_ProvideEstimoteMirrorScanUseCaseFactory.create(builder.useCaseModule, this.provideScannerProvider, this.provideRssiExpirationCacheFactoryProvider));
        this.providesPacketProvider = DoubleCheck.provider(PacketProviderModule_ProvidesPacketProviderFactory.create(builder.packetProviderModule, this.provideIBeaconScanUseCaseProvider, this.provideEddystoneUidScanUseCaseProvider, this.provideEstimoteLocationScanUseCaseProvider, this.provideEstimoteMeshScanUseCaseProvider, this.provideEstimoteConnectivityScanUseCaseProvider, this.provideEstimoteNearableScanUseCaseProvider, this.provideEstimoteUwbScanUseCaseProvider, this.provideEstimoteMirrorScanUseCaseProvider));
        this.providePacketProviderServiceWrapperStarterProvider = DoubleCheck.provider(EstimoteScanningSdkModule_ProvidePacketProviderServiceWrapperStarterFactory.create(builder.estimoteScanningSdkModule));
        this.estimoteBluetoothScannerFactoryMembersInjector = EstimoteBluetoothScannerFactory_MembersInjector.create(this.providesPacketProvider, this.providePacketProviderServiceWrapperStarterProvider);
        this.packetProviderWrapperServiceMembersInjector = PacketProviderWrapperService_MembersInjector.create(this.providePacketProviderServiceWrapperStarterProvider, this.providesPacketProvider);
    }

    @Override
    public void inject(EstimoteBluetoothScannerFactory p0) {
        this.estimoteBluetoothScannerFactoryMembersInjector.injectMembers((Object)p0);
    }

    @Override
    public void inject(PacketProviderWrapperService p0) {
        this.packetProviderWrapperServiceMembersInjector.injectMembers((Object)p0);
    }

    public static final class Builder {
        private BluetoothModule bluetoothModule;
        private ScannerModule scannerModule;
        private UseCaseModule useCaseModule;
        private PacketProviderModule packetProviderModule;
        private EstimoteScanningSdkModule estimoteScanningSdkModule;

        private Builder() {
        }

        public EstimoteScanningSdkComponent build() {
            if (this.bluetoothModule == null) {
                throw new IllegalStateException(BluetoothModule.class.getCanonicalName() + " must be set");
            }
            if (this.scannerModule == null) {
                throw new IllegalStateException(ScannerModule.class.getCanonicalName() + " must be set");
            }
            if (this.useCaseModule == null) {
                this.useCaseModule = new UseCaseModule();
            }
            if (this.packetProviderModule == null) {
                this.packetProviderModule = new PacketProviderModule();
            }
            if (this.estimoteScanningSdkModule == null) {
                this.estimoteScanningSdkModule = new EstimoteScanningSdkModule();
            }
            return new DaggerEstimoteScanningSdkComponent(this);
        }

        public Builder estimoteScanningSdkModule(EstimoteScanningSdkModule estimoteScanningSdkModule) {
            this.estimoteScanningSdkModule = (EstimoteScanningSdkModule)Preconditions.checkNotNull((Object)estimoteScanningSdkModule);
            return this;
        }

        public Builder bluetoothModule(BluetoothModule bluetoothModule) {
            this.bluetoothModule = (BluetoothModule)Preconditions.checkNotNull((Object)bluetoothModule);
            return this;
        }

        public Builder scannerModule(ScannerModule scannerModule) {
            this.scannerModule = (ScannerModule)Preconditions.checkNotNull((Object)scannerModule);
            return this;
        }

        public Builder useCaseModule(UseCaseModule useCaseModule) {
            this.useCaseModule = (UseCaseModule)Preconditions.checkNotNull((Object)useCaseModule);
            return this;
        }

        public Builder packetProviderModule(PacketProviderModule packetProviderModule) {
            this.packetProviderModule = (PacketProviderModule)Preconditions.checkNotNull((Object)packetProviderModule);
            return this;
        }
    }
}

