package com.estimote.scanning_sdk.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.EstimoteMirrorPacket
import com.estimote.scanning_sdk.packet_provider.EstimoteUwbPacket
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_sdk.settings.MirrorScanSettings
import com.estimote.scanning_sdk.settings.UwbScanSettings
import io.reactivex.Observable

/**
 * @author lukasz.pobereznik@estimote.com (Lukasz Pobereznik).
 */
internal class EstimoteMirrorScanUseCase(private val estimoteScanner: EstimoteScanner,
                                         private val recognizer: EstimoteScanResultRecognizer,
                                         private val parser: EstimoteScanResultParser<EstimoteMirrorPacket>,
                                         private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: MirrorScanSettings): Observable<EstimoteMirrorPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteMirrorPacket.smoothRssi(): EstimoteMirrorPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}