package com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanSettings
import android.os.Build
import com.estimote.scanning_sdk.settings.*

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class SamsungScanSettingsTransformer: ScanSettingsVisitor<ScanSettings>{

    override fun visit(estimoteScanResult: IBeaconScanSettings): ScanSettings =
            getSettingsByPowerMode(estimoteScanResult.powerMode)

    override fun visit(estimoteScanResult: EddystoneScanSettings): ScanSettings =
            getSettingsByPowerMode(estimoteScanResult.powerMode)

    override fun visit(telemetryScanSettings: EstimoteTelemetryScanSettings): ScanSettings =
            getSettingsByPowerMode(telemetryScanSettings.powerMode)

    override fun visit(estimoteLocationScanSettings: EstimoteLocationScanSettings): ScanSettings =
            getSettingsByPowerMode(estimoteLocationScanSettings.powerMode)

    override fun visit(estimoteMeshScanSettings: EstimoteMeshScanSettings): ScanSettings =
            getSettingsByPowerMode(estimoteMeshScanSettings.powerMode)

    override fun visit(mirrorScanSettings: MirrorScanSettings): ScanSettings =
            getSettingsByPowerMode(mirrorScanSettings.powerMode)

    override fun visit(uwbScanSettings: UwbScanSettings): ScanSettings =
            getSettingsByPowerMode(uwbScanSettings.powerMode)

    override fun visit(nearableScanSettings: NearableScanSettings): ScanSettings =
            getSettingsByPowerMode(nearableScanSettings.powerMode)

    override fun visit(connectivityScanSettings: ConnectivityScanSettings): ScanSettings =
            getSettingsByPowerMode(connectivityScanSettings.powerMode)

    private fun getSettingsByPowerMode(powerMode: EstimoteScanSettings.ScanPowerMode): ScanSettings = when(powerMode) {
        EstimoteScanSettings.ScanPowerMode.LOW_LATENCY -> ScanSettings.Builder().setReportDelay(0).setScanMode(ScanSettings.SCAN_MODE_LOW_LATENCY).build()
        EstimoteScanSettings.ScanPowerMode.BALANCED -> ScanSettings.Builder().setReportDelay(1).setScanMode(ScanSettings.SCAN_MODE_BALANCED).build()
        EstimoteScanSettings.ScanPowerMode.LOW_POWER -> ScanSettings.Builder().setReportDelay(1).setScanMode(ScanSettings.SCAN_MODE_LOW_POWER).build()
    }

}