package com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_sdk.settings.MirrorScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToMirrorFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): DefaultScanFiltersTransformer.ScanFilterTransformer<MirrorScanSettings> {
    private val MIRROR_FRAME_TYPE_DATA = byteArrayOf(0x06)
    private val MIRROR_FRAME_TYPE_MASK = byteArrayOf(0x0F)

    override fun transform(settings: MirrorScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setServiceData(servicesUuidConfig.estimoteUUID, MIRROR_FRAME_TYPE_DATA, MIRROR_FRAME_TYPE_MASK)
                .build())
    }
}