package com.estimote.scanning_sdk.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer
import java.util.*

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteUwbRecognizer : EstimoteScanResultRecognizer {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))
    private val ESTIMOTE_LOCATION_FRAME_TYPE = 4
    private val ESTIMOTE_LOCATION_V1_FRAME_SIZE = 20



    override fun recognize(result: EstimoteScanResult): Boolean {
        return result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID) != null
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID).isNotEmpty()
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID).size == ESTIMOTE_LOCATION_V1_FRAME_SIZE
                && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID)[0].toInt() and 0x0F == ESTIMOTE_LOCATION_FRAME_TYPE
    }
}