package com.estimote.scanning_sdk.dagger

import android.annotation.TargetApi
import android.content.Context
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.service.PacketProviderWrapperService
import com.estimote.scanning_sdk.api.EstimoteBluetoothScannerFactory


@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class Dagger private constructor(private val applicationContext: Context) {
    private val scanningSdkComponent = DaggerEstimoteScanningSdkComponent.builder()
            .estimoteScanningSdkModule(EstimoteScanningSdkModule())
            .bluetoothModule(BluetoothModule(applicationContext))
            .packetProviderModule(PacketProviderModule())
            .scannerModule(ScannerModule(android.os.Build.VERSION.SDK_INT, android.os.Build.MANUFACTURER))
            .useCaseModule(UseCaseModule())
            .build()


    companion object {
        private var instance: Dagger? = null
        private val DAGGER: Dagger get() =  instance ?: throw IllegalStateException("Dagger needs to be initialized first!")
        fun create(applicationContext: Context): Dagger { return Dagger(applicationContext).also { instance = it }}
        fun injectInTo(bluetoothScannerFactory: EstimoteBluetoothScannerFactory) = DAGGER.scanningSdkComponent.inject(bluetoothScannerFactory)
        fun injectInTo(packetProviderWrapperService: PacketProviderWrapperService) = DAGGER.scanningSdkComponent.inject(packetProviderWrapperService)
    }
}