package com.estimote.scanning_sdk.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EstimoteUwb
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import com.estimote.scanning_sdk.settings.UwbScanSettings

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */
internal class SimpleEstimoteUwbScanLauncher(useCase: ScanUseCase<UwbScanSettings, EstimoteUwb>) : BaseScanLauncher<UwbScanSettings, EstimoteUwb, SimpleEstimoteUwbScanLauncher> (useCase), BluetoothScanner.EstimoteUwbScanLauncher {
    override val buildSettings: (SimpleEstimoteUwbScanLauncher) -> UwbScanSettings = {UwbScanSettings(it.powerMode)}
}