package com.estimote.scanning_sdk.packet_provider.scanner

import android.annotation.TargetApi
import android.bluetooth.le.BluetoothLeScanner
import android.os.Build.VERSION_CODES.*
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.DefaultScanSettingsTransformer
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.SamsungScanSettingsTransformer
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EstimoteScannerFactory(private val bluetoothLeScanner: BluetoothLeScanner) : ScannerFactory {

    override fun create(androidVersion: Int, manufacturerId: String): EstimoteScanner = when (androidVersion) {
        KITKAT -> DummyEstimoteScanner()
        LOLLIPOP, LOLLIPOP_MR1, M, N, N_MR1, O -> createPostLollipopScanner(manufacturerId)
        else -> DummyEstimoteScanner()
    }

    private fun createPostLollipopScanner(manufacturerId: String) = when {
        manufacturerId.isSamsungDevice() -> createPostLollipopScannerForSamsungDevices()
        else -> createPostLollipopDefaultScanner()
    }

    @TargetApi(N)
    private fun createPostLollipopDefaultScanner() =
            PostLollipopEstimoteScanner(
                    bluetoothLeScanner,
                    DefaultScanSettingsTransformer(),
                    createDefaultScanFiltersTransformer())

    @TargetApi(N)
    private fun createPostLollipopScannerForSamsungDevices(): EstimoteScanner {
        return PostLollipopEstimoteScanner(
                bluetoothLeScanner,
                SamsungScanSettingsTransformer(),
                createDefaultScanFiltersTransformer())
    }

    @TargetApi(N)
    private fun createDefaultScanFiltersTransformer() = DefaultScanFiltersTransformer(
            ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
            ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToUwbFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToNearableFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
            ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()))


    private fun String.isSamsungDevice() = this.equals("samsung", ignoreCase = true)

}