/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.rssi_smoothers;

import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother;
import kotlin.Metadata;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/FastPredictiveVarianceRssiSmoother;", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/RssiSmoother;", "()V", "INITIAL_RSSI", "", "INITIAL_VARIANCE", "RSSI_MEASUREMENT_NOISE_VARIANCE", "RSSI_MODEL_NOISE", "RSSI_VELOCITY_MODEL_NOISE", "filteredRssi", "lastUpdateTimeSeconds", "pVV", "pVX", "pXV", "pXX", "v", "x", "smooth", "rssi", "", "timestampSeconds", "scanning-sdk_release"})
public final class FastPredictiveVarianceRssiSmoother
implements RssiSmoother {
    private final double INITIAL_RSSI = -90.0;
    private final double INITIAL_VARIANCE = 1.0E12;
    private final double RSSI_MEASUREMENT_NOISE_VARIANCE = 25.0;
    private final double RSSI_MODEL_NOISE = 0.1;
    private final double RSSI_VELOCITY_MODEL_NOISE = 0.01;
    private double x = this.INITIAL_RSSI;
    private double v = 0.0;
    private double pXX;
    private double pXV = 0.0;
    private double pVX = 0.0;
    private double pVV;
    private double filteredRssi = this.x;
    private double lastUpdateTimeSeconds;

    @Override
    public double smooth(int rssi, double timestampSeconds) {
        double newRssi = rssi;
        double dT = 0.0;
        if (this.lastUpdateTimeSeconds > 0.0) {
            dT = timestampSeconds - this.lastUpdateTimeSeconds;
        }
        this.lastUpdateTimeSeconds = timestampSeconds;
        double x = this.x;
        double v = this.v;
        double pXX = this.pXX;
        double pXV = this.pXV;
        double pVX = this.pVX;
        double pVV = this.pVV;
        this.v = v - (dT * pVV + pVX) * (-newRssi + dT * v + x) / (dT * (dT * pVV + pVX + pXV) + pXX + this.RSSI_MEASUREMENT_NOISE_VARIANCE + dT * this.RSSI_MODEL_NOISE);
        this.x = newRssi + this.RSSI_MEASUREMENT_NOISE_VARIANCE * (-newRssi + dT * v + x) / (dT * (dT * pVV + pVX + pXV) + pXX + this.RSSI_MEASUREMENT_NOISE_VARIANCE + dT * this.RSSI_MODEL_NOISE);
        this.pVV = pVV + dT * this.RSSI_VELOCITY_MODEL_NOISE - (dT * pVV + pVX) * (dT * pVV + pXV) / (dT * (dT * pVV + pVX + pXV) + pXX + this.RSSI_MEASUREMENT_NOISE_VARIANCE + dT * this.RSSI_MODEL_NOISE);
        this.pXV = this.pVX = (dT * pVV + pVX) * this.RSSI_MEASUREMENT_NOISE_VARIANCE / (dT * (dT * pVV + pVX + pXV) + pXX + this.RSSI_MEASUREMENT_NOISE_VARIANCE + dT * this.RSSI_MODEL_NOISE);
        this.pXX = this.RSSI_MEASUREMENT_NOISE_VARIANCE - this.RSSI_MEASUREMENT_NOISE_VARIANCE * this.RSSI_MEASUREMENT_NOISE_VARIANCE / (dT * (dT * pVV + pVX + pXV) + pXX + this.RSSI_MEASUREMENT_NOISE_VARIANCE + dT * this.RSSI_MODEL_NOISE);
        this.filteredRssi = this.x;
        return this.filteredRssi;
    }

    public FastPredictiveVarianceRssiSmoother() {
        this.pXX = this.INITIAL_VARIANCE;
        this.pVV = this.INITIAL_VARIANCE;
    }
}

