package com.estimote.scanning_sdk.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.EstimoteLocationPacket
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_sdk.settings.EstimoteLocationScanSettings
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EstimoteLocationScanUseCase(private val estimoteScanner: EstimoteScanner,
                                           private val recognizer: EstimoteScanResultRecognizer,
                                           private val parser: EstimoteScanResultParser<EstimoteLocationPacket>,
                                           private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: EstimoteLocationScanSettings): Observable<EstimoteLocationPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteLocationPacket.smoothRssi(): EstimoteLocationPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }

}