package com.estimote.scanning_sdk.packet_provider.rssi_smoothers

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class TimeExpirationPolicy(private val expirationTimeMillis: Long, private val timer: Timer) : ExpirationPolicy {

    override fun hasExpired(timestamp: Long): Boolean =
            timer.getCurrentTimeMillis() - timestamp >= expirationTimeMillis
}