package com.estimote.scanning_sdk.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.internal_plugins_api.scanning.DeviceType
import com.estimote.internal_plugins_api.scanning.MacAddress
import com.estimote.scanning_sdk.common.toHex
import com.estimote.scanning_sdk.packet_provider.EstimoteConnectivityPacket
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser
import java.nio.ByteBuffer
import java.util.*

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteConnectivityParser: EstimoteScanResultParser<EstimoteConnectivityPacket> {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))

    override fun parse(result: EstimoteScanResult): EstimoteConnectivityPacket {
        val bytes = ByteBuffer.wrap(result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID))
        with(bytes) {
            return EstimoteConnectivityPacket(
                    getDeviceId(),
                    getDeviceType(),
                    getBootloaderVersion(),
                    getApplicationVersion(),
                    getShakeToConnect(),
                    getNearToConnect(),
                    EstimoteMacAddress(result.device.address),
                    result.rssi,
                    result.timestampNanosSinceBoot
            )
        }
    }

    private fun ByteBuffer.getDeviceId(): String {
        val bytes = ByteArray(16)
        position(1)
        get(bytes, 0, 16)
        return bytes.toHex()
    }

    private fun ByteBuffer.getDeviceType(): DeviceType {
        return DeviceType.LOCATION_BEACON
    }

    private fun ByteBuffer.getBootloaderVersion(): String {
        return "TBD"
    }

    private fun ByteBuffer.getApplicationVersion(): String {
        return "TBD"
    }

    private fun ByteBuffer.getShakeToConnect(): Boolean {
        return false //TBD
    }

    private fun ByteBuffer.getNearToConnect(): Boolean {
        return false //TBD
    }
}