package com.estimote.scanning_sdk.api.use_cases

import com.estimote.scanning_sdk.packet_provider.PacketProvider
import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import io.reactivex.Observable
import io.reactivex.disposables.Disposable

internal class ScanUseCase<in SETTINGS_TYPE, out PACKET_TYPE>(private val loadPacketProvider: () -> Observable<PacketProvider>, private val startScan: (PacketProvider, SETTINGS_TYPE) -> Observable<out PACKET_TYPE>) {

    fun run(settings: SETTINGS_TYPE, onPacketFound: (PACKET_TYPE)->Unit, onErrorOccurred: (Throwable) -> Unit) =
        whenPacketProviderGetsReady()
                .scanForPacketsAccordingToSettings(settings)
                .notifyUserCallbacks(onPacketFound, onErrorOccurred)
                .createHandlerForThisScanRequest()

    private fun whenPacketProviderGetsReady() =
            loadPacketProvider()

    private fun Observable<PacketProvider>.scanForPacketsAccordingToSettings(settings: SETTINGS_TYPE) =
            this.flatMap { startScan(it, settings) }

    private fun Observable<PACKET_TYPE>.notifyUserCallbacks(onPacketFound: (PACKET_TYPE) -> Unit, onErrorOccurred: (Throwable) -> Unit) =
            this.subscribe({ onPacketFound(it) }, { onErrorOccurred(it) })

    private fun Disposable.createHandlerForThisScanRequest() =
            this.let { RxScanHandler(it) }
}