/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.dagger;

import android.annotation.TargetApi;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkScope;
import com.estimote.scanning_sdk.packet_provider.parsers.EddystoneUidParser;
import com.estimote.scanning_sdk.packet_provider.parsers.EstimoteConnectivityParser;
import com.estimote.scanning_sdk.packet_provider.parsers.EstimoteLocationV1Parser;
import com.estimote.scanning_sdk.packet_provider.parsers.EstimoteMeshParser;
import com.estimote.scanning_sdk.packet_provider.parsers.EstimoteNearableParser;
import com.estimote.scanning_sdk.packet_provider.parsers.IBeaconParser;
import com.estimote.scanning_sdk.packet_provider.recognizers.EddystoneUidRecognizer;
import com.estimote.scanning_sdk.packet_provider.recognizers.EstimoteConnectivityRecognizer;
import com.estimote.scanning_sdk.packet_provider.recognizers.EstimoteLocationV1Recognizer;
import com.estimote.scanning_sdk.packet_provider.recognizers.EstimoteMeshRecognizer;
import com.estimote.scanning_sdk.packet_provider.recognizers.EstimoteNearableRecognizer;
import com.estimote.scanning_sdk.packet_provider.recognizers.IBeaconRecognizer;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.AndroidTimer;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.RssiSmootherExpirationCacheFactory;
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.Timer;
import com.estimote.scanning_sdk.packet_provider.use_cases.EddystoneUidScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteConnectivityScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteLocationScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteMeshScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteNearableScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_sdk.packet_provider.use_cases.IBeaconScanUseCase;
import dagger.Module;
import dagger.Provides;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0015H\u0007\u00a8\u0006\u0017"}, d2={"Lcom/estimote/scanning_sdk/dagger/UseCaseModule;", "", "()V", "provideEddystoneUidScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EddystoneUidScanUseCase;", "estimoteScanner", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "rssiSmootherExpirationCacheFactory", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/RssiSmootherExpirationCacheFactory;", "provideEstimoteConnectivityScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteConnectivityScanUseCase;", "provideEstimoteLocationScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteLocationScanUseCase;", "provideEstimoteMeshScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteMeshScanUseCase;", "provideEstimoteNearableScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteNearableScanUseCase;", "provideIBeaconScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/IBeaconScanUseCase;", "provideRssiExpirationCacheFactory", "timer", "Lcom/estimote/scanning_sdk/packet_provider/rssi_smoothers/Timer;", "provideTimer", "scanning-sdk_release"})
@TargetApi(value=21)
public final class UseCaseModule {
    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final Timer provideTimer() {
        return new AndroidTimer();
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final RssiSmootherExpirationCacheFactory provideRssiExpirationCacheFactory(@NotNull Timer timer) {
        Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
        return new RssiSmootherExpirationCacheFactory(timer);
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final IBeaconScanUseCase provideIBeaconScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new IBeaconScanUseCase(estimoteScanner, new IBeaconRecognizer(), new IBeaconParser(), rssiSmootherExpirationCacheFactory.create());
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EddystoneUidScanUseCase provideEddystoneUidScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new EddystoneUidScanUseCase(estimoteScanner, new EddystoneUidRecognizer(), new EddystoneUidParser(), rssiSmootherExpirationCacheFactory.create());
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteLocationScanUseCase provideEstimoteLocationScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new EstimoteLocationScanUseCase(estimoteScanner, new EstimoteLocationV1Recognizer(), new EstimoteLocationV1Parser(), rssiSmootherExpirationCacheFactory.create());
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteMeshScanUseCase provideEstimoteMeshScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new EstimoteMeshScanUseCase(estimoteScanner, new EstimoteMeshRecognizer(), new EstimoteMeshParser(), rssiSmootherExpirationCacheFactory.create());
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteConnectivityScanUseCase provideEstimoteConnectivityScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new EstimoteConnectivityScanUseCase(estimoteScanner, new EstimoteConnectivityRecognizer(), new EstimoteConnectivityParser(), rssiSmootherExpirationCacheFactory.create());
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteNearableScanUseCase provideEstimoteNearableScanUseCase(@NotNull EstimoteScanner estimoteScanner, @NotNull RssiSmootherExpirationCacheFactory rssiSmootherExpirationCacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)estimoteScanner, (String)"estimoteScanner");
        Intrinsics.checkParameterIsNotNull((Object)rssiSmootherExpirationCacheFactory, (String)"rssiSmootherExpirationCacheFactory");
        return new EstimoteNearableScanUseCase(estimoteScanner, new EstimoteNearableRecognizer(), new EstimoteNearableParser(), rssiSmootherExpirationCacheFactory.create());
    }
}

