package com.estimote.scanning_sdk.packet_provider.scanner

import android.annotation.TargetApi
import android.bluetooth.le.*
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner

import com.estimote.scanning_sdk.settings.ScanSettingsVisitor
import com.estimote.scanning_sdk.settings.EstimoteScanSettings
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
// TODO: HANDLE EXCEPTION FOR ERRORS IN BLE
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class PostLollipopEstimoteScanner(private val bluetoothLeScanner: BluetoothLeScanner,
                                           private val scanSettingsTransformer: ScanSettingsVisitor<ScanSettings>,
                                           private val scanFiltersTransformer: ScanSettingsVisitor<List<ScanFilter>>) : EstimoteScanner {

    @TargetApi(Build.VERSION_CODES.N)
    override fun scan(scanSettings: EstimoteScanSettings): Observable<EstimoteScanResult> {
        return Observable.create { emitter ->
            val callback = object : ScanCallback() {
                override fun onScanResult(callbackType: Int, result: ScanResult) = emitter.onNext(result.toEstimoteScanResult())
                override fun onBatchScanResults(results: MutableList<ScanResult>) = results.forEach { emitter.onNext(it.toEstimoteScanResult()) }
                override fun onScanFailed(errorCode: Int) = emitter.onError(Exception("Bluetooth Low Energy scan failed with error code: $errorCode"))
            }
            emitter.setCancellable { bluetoothLeScanner.stopScan(callback) }
            bluetoothLeScanner.startScan(scanSettings.accept(scanFiltersTransformer), scanSettings.accept(scanSettingsTransformer), callback)
        }
    }

    private fun ScanResult.toEstimoteScanResult() = EstimoteScanResult(device, rssi, timestampNanos, scanRecord)
}