package com.estimote.scanning_sdk.packet_provider

import android.annotation.TargetApi
import android.os.Build
import com.estimote.internal_plugins_api.scanning.*
import com.estimote.scanning_sdk.packet_provider.use_cases.*
import com.estimote.scanning_sdk.settings.*
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EstimotePacketProvider(private val iBeaconScanUseCase: IBeaconScanUseCase,
                             private val eddystoneUidScanUseCase: EddystoneUidScanUseCase,
                             private val estimoteLocationScanUseCase: EstimoteLocationScanUseCase,
                             private val estimoteMeshScanUseCase: EstimoteMeshScanUseCase,
                             private val estimoteConnectivityScanUseCase: EstimoteConnectivityScanUseCase,
                             private val estimoteNearableScanUseCase: EstimoteNearableScanUseCase) : PacketProvider {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideIBeacon(scanSettings: IBeaconScanSettings): Observable<out Beacon> {
        return iBeaconScanUseCase.run(scanSettings)
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideEddystoneUid(scanSettings: EddystoneScanSettings): Observable<out EddystoneUid> {
        return eddystoneUidScanUseCase.run(scanSettings)
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideEstimoteLocation(scanSettings: EstimoteLocationScanSettings): Observable<out EstimoteLocation> {
        return estimoteLocationScanUseCase.run(scanSettings).map { it as EstimoteLocation }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideEstimoteMesh(scanSettings: EstimoteMeshScanSettings): Observable<out EstimoteMesh> {
        return estimoteMeshScanUseCase.run(scanSettings).map { it as EstimoteMesh }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideConnectivity(scanSettings: ConnectivityScanSettings): Observable<out EstimoteConnectivity> {
        return estimoteConnectivityScanUseCase.run(scanSettings).map { it as EstimoteConnectivity }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun provideNearable(scanSettings: NearableScanSettings): Observable<out EstimoteNearable> {
        return estimoteNearableScanUseCase.run(scanSettings).map { it as EstimoteNearable }
    }
}