package com.estimote.scanning_sdk.dagger

import com.estimote.scanning_sdk.packet_provider.EstimotePacketProvider
import com.estimote.scanning_sdk.packet_provider.PacketProvider
import com.estimote.scanning_sdk.packet_provider.use_cases.*
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
internal class PacketProviderModule {

    @Provides
    @EstimoteScanningSdkScope
    fun providesPacketProvider(iBeaconScanUseCase: IBeaconScanUseCase,
                               eddystoneUidScanUseCase: EddystoneUidScanUseCase,
                               estimoteLocationScanUseCase: EstimoteLocationScanUseCase,
                               estimoteMeshScanUseCase: EstimoteMeshScanUseCase,
                               estimoteConnectivityScanUseCase: EstimoteConnectivityScanUseCase,
                               estimoteNearableScanUseCase: EstimoteNearableScanUseCase): PacketProvider =
            EstimotePacketProvider(iBeaconScanUseCase, eddystoneUidScanUseCase, estimoteLocationScanUseCase, estimoteMeshScanUseCase, estimoteConnectivityScanUseCase, estimoteNearableScanUseCase)

}