package com.estimote.scanning_sdk.api

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.scanning_sdk.packet_provider.PacketProvider
import com.estimote.scanning_sdk.api.scan_launchers.*
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import io.reactivex.Observable


internal class EstimoteBluetoothScanner(private val packetProvider: () -> Observable<PacketProvider>) : BluetoothScanner {

    override fun beaconScan() =
            SimpleBeaconScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideIBeacon(settings) }))

    override fun estimoteLocationScan() =
            SimpleEstimoteLocationScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteLocation(settings) }))

    override fun eddystoneUidScan() =
            SimpleEddystoneUidScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEddystoneUid(settings) }))

    override fun estimoteMeshScan() =
            SimpleEstimoteMeshScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideEstimoteMesh(settings) }))

    override fun estimoteConnectivityScan() =
            SimpleEstimoteConnectivityScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideConnectivity(settings) }))

    override fun estimoteNearableScan() =
            SimpleEstimoteNearableScanLauncher(ScanUseCase(packetProvider, { packetProvider, settings -> packetProvider.provideNearable(settings) }))

}