/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider;

import android.annotation.TargetApi;
import com.estimote.internal_plugins_api.scanning.Beacon;
import com.estimote.internal_plugins_api.scanning.EddystoneUid;
import com.estimote.internal_plugins_api.scanning.EstimoteConnectivity;
import com.estimote.internal_plugins_api.scanning.EstimoteLocation;
import com.estimote.internal_plugins_api.scanning.EstimoteMesh;
import com.estimote.scanning_sdk.packet_provider.EstimotePacketProvider;
import com.estimote.scanning_sdk.packet_provider.PacketProvider;
import com.estimote.scanning_sdk.packet_provider.use_cases.EddystoneUidScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteConnectivityScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteLocationScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteMeshScanUseCase;
import com.estimote.scanning_sdk.packet_provider.use_cases.IBeaconScanUseCase;
import com.estimote.scanning_sdk.settings.ConnectivityScanSettings;
import com.estimote.scanning_sdk.settings.EddystoneScanSettings;
import com.estimote.scanning_sdk.settings.EstimoteLocationScanSettings;
import com.estimote.scanning_sdk.settings.EstimoteMeshScanSettings;
import com.estimote.scanning_sdk.settings.IBeaconScanSettings;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u000e2\u0006\u0010\u0010\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u000e2\u0006\u0010\u0010\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u000e2\u0006\u0010\u0010\u001a\u00020\u001dH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/EstimotePacketProvider;", "Lcom/estimote/scanning_sdk/packet_provider/PacketProvider;", "iBeaconScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/IBeaconScanUseCase;", "eddystoneUidScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EddystoneUidScanUseCase;", "estimoteLocationScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteLocationScanUseCase;", "estimoteMeshScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteMeshScanUseCase;", "estimoteConnectivityScanUseCase", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteConnectivityScanUseCase;", "(Lcom/estimote/scanning_sdk/packet_provider/use_cases/IBeaconScanUseCase;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EddystoneUidScanUseCase;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteLocationScanUseCase;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteMeshScanUseCase;Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteConnectivityScanUseCase;)V", "provideConnectivity", "Lio/reactivex/Observable;", "Lcom/estimote/internal_plugins_api/scanning/EstimoteConnectivity;", "scanSettings", "Lcom/estimote/scanning_sdk/settings/ConnectivityScanSettings;", "provideEddystoneUid", "Lcom/estimote/internal_plugins_api/scanning/EddystoneUid;", "Lcom/estimote/scanning_sdk/settings/EddystoneScanSettings;", "provideEstimoteLocation", "Lcom/estimote/internal_plugins_api/scanning/EstimoteLocation;", "Lcom/estimote/scanning_sdk/settings/EstimoteLocationScanSettings;", "provideEstimoteMesh", "Lcom/estimote/internal_plugins_api/scanning/EstimoteMesh;", "Lcom/estimote/scanning_sdk/settings/EstimoteMeshScanSettings;", "provideIBeacon", "Lcom/estimote/internal_plugins_api/scanning/Beacon;", "Lcom/estimote/scanning_sdk/settings/IBeaconScanSettings;", "scanning-sdk_release"})
public final class EstimotePacketProvider
implements PacketProvider {
    private final IBeaconScanUseCase iBeaconScanUseCase;
    private final EddystoneUidScanUseCase eddystoneUidScanUseCase;
    private final EstimoteLocationScanUseCase estimoteLocationScanUseCase;
    private final EstimoteMeshScanUseCase estimoteMeshScanUseCase;
    private final EstimoteConnectivityScanUseCase estimoteConnectivityScanUseCase;

    @Override
    @TargetApi(value=21)
    @NotNull
    public Observable<? extends Beacon> provideIBeacon(@NotNull IBeaconScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        return this.iBeaconScanUseCase.run(scanSettings);
    }

    @Override
    @TargetApi(value=21)
    @NotNull
    public Observable<? extends EddystoneUid> provideEddystoneUid(@NotNull EddystoneScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        return this.eddystoneUidScanUseCase.run(scanSettings);
    }

    @Override
    @TargetApi(value=21)
    @NotNull
    public Observable<? extends EstimoteLocation> provideEstimoteLocation(@NotNull EstimoteLocationScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = this.estimoteLocationScanUseCase.run(scanSettings).map((Function)provideEstimoteLocation.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"estimoteLocationScanUseC\u2026 it as EstimoteLocation }");
        return observable;
    }

    @Override
    @TargetApi(value=21)
    @NotNull
    public Observable<? extends EstimoteMesh> provideEstimoteMesh(@NotNull EstimoteMeshScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = this.estimoteMeshScanUseCase.run(scanSettings).map((Function)provideEstimoteMesh.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"estimoteMeshScanUseCase.\u2026ap { it as EstimoteMesh }");
        return observable;
    }

    @Override
    @TargetApi(value=21)
    @NotNull
    public Observable<? extends EstimoteConnectivity> provideConnectivity(@NotNull ConnectivityScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = this.estimoteConnectivityScanUseCase.run(scanSettings).map((Function)provideConnectivity.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"estimoteConnectivityScan\u2026as EstimoteConnectivity }");
        return observable;
    }

    public EstimotePacketProvider(@NotNull IBeaconScanUseCase iBeaconScanUseCase, @NotNull EddystoneUidScanUseCase eddystoneUidScanUseCase, @NotNull EstimoteLocationScanUseCase estimoteLocationScanUseCase, @NotNull EstimoteMeshScanUseCase estimoteMeshScanUseCase, @NotNull EstimoteConnectivityScanUseCase estimoteConnectivityScanUseCase) {
        Intrinsics.checkParameterIsNotNull((Object)iBeaconScanUseCase, (String)"iBeaconScanUseCase");
        Intrinsics.checkParameterIsNotNull((Object)eddystoneUidScanUseCase, (String)"eddystoneUidScanUseCase");
        Intrinsics.checkParameterIsNotNull((Object)estimoteLocationScanUseCase, (String)"estimoteLocationScanUseCase");
        Intrinsics.checkParameterIsNotNull((Object)estimoteMeshScanUseCase, (String)"estimoteMeshScanUseCase");
        Intrinsics.checkParameterIsNotNull((Object)estimoteConnectivityScanUseCase, (String)"estimoteConnectivityScanUseCase");
        this.iBeaconScanUseCase = iBeaconScanUseCase;
        this.eddystoneUidScanUseCase = eddystoneUidScanUseCase;
        this.estimoteLocationScanUseCase = estimoteLocationScanUseCase;
        this.estimoteMeshScanUseCase = estimoteMeshScanUseCase;
        this.estimoteConnectivityScanUseCase = estimoteConnectivityScanUseCase;
    }
}

