package com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer.ScanFilterTransformer
import com.estimote.scanning_sdk.settings.NearableScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToNearableFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): ScanFilterTransformer<NearableScanSettings> {
    private val ESTIMOTE_MANUFACTURER_ID = 0x015D

    override fun transform(settings: NearableScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setManufacturerData(ESTIMOTE_MANUFACTURER_ID, byteArrayOf())
                .build())
    }
}