package com.estimote.scanning_sdk.packet_provider

import com.estimote.internal_plugins_api.scanning.*
import java.util.*

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
data class BeaconPacket(
        override val proximityUUID: UUID,
        override val major: Int,
        override val minor: Int,
        override val macAddress: MacAddress,
        override val measuredPower: Int,
        override val rssi: Int,
        override val timestamp: Long) : Beacon

data class EstimoteLocationPacket(
        override val deviceId: String,
        override val channel: Int,
        override val protocolVersion: Int,
        override val measuredPower: Int,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteLocation


data class EddystoneUidPacket(
        override val namespace: String,
        override val instance: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EddystoneUid

data class EddystoneUrlPacket(
        override val url: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EddystoneUrl

data class EstimoteConnectivityPacket(
        override val deviceId: String,
        override val deviceType: DeviceType,
        override val bootloaderVersion: String,
        override val appVersion: String,
        override val shakeToConnect: Boolean,
        override val nearToConnect: Boolean,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteConnectivity

data class EstimoteMeshPacket(
        override val deviceId: String,
        override val meshReportHash: Int,
        override val meshId: Int,
        override val settingsVersion: Int,
        override val appVersion: String,
        override val bootloaderVersion: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long): EstimoteMesh

data class EstimoteMacAddress(override val address: String): MacAddress